/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinitionVisitor;

public class ObjectTypeVisitor
implements TypeDefinitionVisitor {
    public static final Class<ArrayList> DEFAULT_COLLECTION_TYPE = ArrayList.class;
    private static final Class<HashMap> DEFAULT_MAP_TYPE = HashMap.class;
    private static final Class<HashSet> DEFAULT_SET_CLASS = HashSet.class;
    private final ComponentAst componentModel;
    private Class<?> type;
    private Optional<TypeDefinition.MapEntryType> mapEntryType = Optional.empty();

    public ObjectTypeVisitor(ComponentAst componentModel) {
        this.componentModel = componentModel;
    }

    @Override
    public void onType(Class<?> type) {
        this.type = this.resolveType(type);
    }

    private Class<?> resolveType(Class<?> type) {
        if (Collection.class.equals(type) || List.class.equals(type)) {
            return DEFAULT_COLLECTION_TYPE;
        }
        if (Set.class.equals(type)) {
            return DEFAULT_SET_CLASS;
        }
        if (Map.class.equals(type)) {
            return DEFAULT_MAP_TYPE;
        }
        return type;
    }

    @Override
    public void onConfigurationAttribute(String attributeName, Class<?> enforcedClass) {
        this.onConfigurationAttribute("General", attributeName, enforcedClass);
    }

    @Override
    public void onConfigurationAttribute(String groupName, String attributeName, Class<?> enforcedClass) {
        String attributeValue = this.componentModel.getParameter(groupName, attributeName).getResolvedRawValue();
        try {
            this.type = ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)attributeValue);
            if (!enforcedClass.isAssignableFrom(this.type)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Class definition for type %s on element %s is not the same nor inherits from %s", attributeValue, this.componentModel.getIdentifier(), enforcedClass.getName()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Error while trying to locate Class definition for type %s on element %s", attributeValue, this.componentModel.getIdentifier()), (Throwable)e);
        }
    }

    @Override
    public void onMapType(TypeDefinition.MapEntryType mapEntryType) {
        this.type = mapEntryType.getClass();
        this.mapEntryType = Optional.of(new TypeDefinition.MapEntryType(this.resolveType(mapEntryType.getKeyType()), this.resolveType(mapEntryType.getValueType())));
    }

    public Class<?> getType() {
        return this.type;
    }

    public Optional<TypeDefinition.MapEntryType> getMapEntryType() {
        return this.mapEntryType;
    }
}

