/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.processor;

import javax.inject.Inject;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.async.AsynchronousRetryTemplate;
import org.mule.runtime.core.api.retry.policy.AbstractPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

public class RetryPolicyTemplateObjectFactory
extends AbstractComponentFactory<RetryPolicyTemplate> {
    private boolean blocking = true;
    private Integer count = 2;
    private Integer frequency = 2000;
    private RetryNotifier retryNotifier;
    @Inject
    private NotificationDispatcher notificationFirer;

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public void setRetryNotifier(RetryNotifier retryNotifier) {
        this.retryNotifier = retryNotifier;
    }

    @Override
    public RetryPolicyTemplate doGetObject() throws Exception {
        AbstractPolicyTemplate retryPolicyTemplate;
        if (this.count != 0) {
            retryPolicyTemplate = new SimpleRetryPolicyTemplate(this.frequency.intValue(), this.count);
            ((SimpleRetryPolicyTemplate)retryPolicyTemplate).setNotificationFirer(this.notificationFirer);
        } else {
            retryPolicyTemplate = new NoRetryPolicyTemplate();
        }
        if (this.retryNotifier != null) {
            retryPolicyTemplate.setNotifier(this.retryNotifier);
        }
        if (!this.blocking) {
            return new AsynchronousRetryTemplate(retryPolicyTemplate);
        }
        return retryPolicyTemplate;
    }
}

