/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;

public abstract class CreateBeanDefinitionRequest<T> {
    private final List<ComponentAst> componentHierarchy;
    private final ComponentAst component;
    private final Collection<SpringComponentModel> paramsModels;
    private final ComponentBuildingDefinition<T> componentBuildingDefinition;
    private final SpringComponentModel springComponentModel;

    public CreateBeanDefinitionRequest(List<ComponentAst> componentHierarchy, ComponentAst component, Collection<SpringComponentModel> paramsModels, ComponentBuildingDefinition<T> componentBuildingDefinition, ComponentIdentifier componentIdentifier) {
        this.componentHierarchy = componentHierarchy;
        this.component = component;
        this.paramsModels = paramsModels;
        this.componentBuildingDefinition = componentBuildingDefinition;
        this.springComponentModel = new SpringComponentModel();
        this.springComponentModel.setComponentIdentifier(componentIdentifier);
        this.springComponentModel.setComponent(component);
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(component);
        if (componentBuildingDefinition != null) {
            this.springComponentModel.setComponentName(componentBuildingDefinition.getRegistrationName());
            componentBuildingDefinition.getTypeDefinition().visit(objectTypeVisitor);
        } else {
            objectTypeVisitor.onType(Object.class);
        }
        this.springComponentModel.setType(objectTypeVisitor.getType());
        objectTypeVisitor.getMapEntryType().ifPresent(this.springComponentModel::setMapEntryType);
    }

    public List<ComponentAst> getComponentHierarchy() {
        return this.componentHierarchy;
    }

    public ComponentAst getComponent() {
        return this.component;
    }

    public Collection<SpringComponentModel> getParamsModels() {
        return this.paramsModels;
    }

    public ComponentBuildingDefinition<T> getComponentBuildingDefinition() {
        return this.componentBuildingDefinition;
    }

    public SpringComponentModel getSpringComponentModel() {
        return this.springComponentModel;
    }

    public abstract ComponentAst resolveConfigurationComponent();

    protected ComponentAst resolveOwnerComponent() {
        for (int i = this.getComponentHierarchy().size() - 1; i >= 0; --i) {
            ComponentAst possibleOwner = this.getComponentHierarchy().get(i);
            if (!possibleOwner.getModel(ParameterizedModel.class).isPresent()) continue;
            return possibleOwner;
        }
        return null;
    }

    public ComponentParameterAst getParameter(String parameterName) {
        return this.getComponent().getParameters().stream().filter(p -> p.getModel().getName().equals(parameterName)).findFirst().orElse(null);
    }
}

