/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.config.ComponentBuildingDefinitionProviderUtils;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.config.ExtensionBuildingDefinitionProvider;

public final class ComponentBuildingDefinitionUtils {
    private static ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitions;

    public static ComponentBuildingDefinitionProvider getRuntimeComponentBuildingDefinitionProvider() {
        if (runtimeComponentBuildingDefinitions == null) {
            final ArrayList allDefinitions = new ArrayList();
            ComponentBuildingDefinitionProviderUtils.lookupComponentBuildingDefinitionProviders().forEach(componentBuildingDefinitionProvider -> {
                componentBuildingDefinitionProvider.init();
                allDefinitions.addAll(componentBuildingDefinitionProvider.getComponentBuildingDefinitions());
            });
            runtimeComponentBuildingDefinitions = new ComponentBuildingDefinitionProvider(){

                @Override
                public void init() {
                }

                @Override
                public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
                    return allDefinitions;
                }
            };
        }
        return runtimeComponentBuildingDefinitions;
    }

    public static List<ComponentBuildingDefinition> getExtensionModelsComponentBuildingDefinitions(Set<ExtensionModel> extensionModels, DslResolvingContext dslResolvingContext, Function<ExtensionModel, Optional<DslSyntaxResolver>> dslSyntaxResolverLookup) {
        ArrayList<ComponentBuildingDefinition> componentBuildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        ComponentBuildingDefinitionProviderUtils.lookupComponentBuildingDefinitionProviders().forEach(componentBuildingDefinitionProvider -> {
            if (componentBuildingDefinitionProvider instanceof ExtensionBuildingDefinitionProvider) {
                ExtensionBuildingDefinitionProvider extensionBuildingDefinitionProvider = (ExtensionBuildingDefinitionProvider)componentBuildingDefinitionProvider;
                extensionBuildingDefinitionProvider.setExtensionModels(extensionModels);
                extensionBuildingDefinitionProvider.setDslResolvingContext(dslResolvingContext);
                extensionBuildingDefinitionProvider.setDslSyntaxResolverLookup(dslSyntaxResolverLookup);
                extensionBuildingDefinitionProvider.init();
                componentBuildingDefinitions.addAll(extensionBuildingDefinitionProvider.getComponentBuildingDefinitions());
            }
        });
        return componentBuildingDefinitions;
    }

    public static List<ComponentBuildingDefinition> getArtifactComponentBuildingDefinitions(ClassLoader classLoader) {
        ArrayList<ComponentBuildingDefinition> componentBuildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        ComponentBuildingDefinitionProviderUtils.lookupComponentBuildingDefinitionProviders(classLoader).forEach(componentBuildingDefinitionProvider -> {
            if (componentBuildingDefinitionProvider.getClass().getClassLoader().equals(classLoader)) {
                componentBuildingDefinitionProvider.init();
                componentBuildingDefinitions.addAll(componentBuildingDefinitionProvider.getComponentBuildingDefinitions());
            }
        });
        return componentBuildingDefinitions;
    }

    public static void setRuntimeComponentBuildingDefinitions(ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitions) {
        ComponentBuildingDefinitionUtils.runtimeComponentBuildingDefinitions = runtimeComponentBuildingDefinitions;
    }
}

