/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class NamedTopLevelElementsHaveName
implements Validation {
    @Override
    public String getName() {
        return "Named Top-Level elements have name";
    }

    @Override
    public String getDescription() {
        return "'name' attribute in top-level elements is present";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.topLevelElement().and(ComponentAstPredicatesFactory.currentElemement(topLevelComponent -> !topLevelComponent.getComponentId().isPresent())).and(ComponentAstPredicatesFactory.currentElemement(topLevelComponent -> topLevelComponent.getModel(Object.class).isPresent())).and(ComponentAstPredicatesFactory.currentElemement(topLevelComponent -> topLevelComponent.getModel(HasStereotypeModel.class).map(sm -> sm.getStereotype().isAssignableTo(MuleStereotypes.APP_CONFIG)).orElse(false) == false));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst topLevelComponent, ArtifactAst artifact) {
        if (!topLevelComponent.getModel(ConstructModel.class).isPresent() || topLevelComponent.getModel(ParameterizedModel.class).map(pmzd -> pmzd.getAllParameterModels().stream().anyMatch(ParameterModel::isComponentId)).orElse(false).booleanValue()) {
            ComponentIdentifier identifier = topLevelComponent.getIdentifier();
            return Optional.of(ValidationResultItem.create(topLevelComponent, (Validation)this, String.format("Global element '%s' does not provide a name attribute.", identifier.toString())));
        }
        return Optional.empty();
    }
}

