/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;

public class RaiseErrorTypeReferencesPresent
extends AbstractErrorTypesValidation {
    public RaiseErrorTypeReferencesPresent(Optional<FeatureFlaggingService> featureFlaggingService) {
        super(featureFlaggingService, false);
    }

    @Override
    public String getName() {
        return "Error Type references present";
    }

    @Override
    public String getDescription() {
        return "Referenced error types cannot be empty or null.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier(RAISE_ERROR_IDENTIFIER));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst errorTypeParam = this.getErrorTypeParam(component);
        String errorTypeString = errorTypeParam.getResolvedRawValue();
        if (StringUtils.isEmpty((CharSequence)errorTypeString)) {
            return Optional.of(ValidationResultItem.create(component, errorTypeParam, (Validation)this, "type cannot be an empty string or null "));
        }
        return Optional.empty();
    }
}

