/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.bytes;

import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.internal.streaming.ClosingCursorException;
import org.mule.runtime.core.internal.streaming.CursorProviderAlreadyClosedException;

@NoExtend
public abstract class AbstractCursorStreamProvider
extends AbstractComponent
implements CursorStreamProvider {
    protected final InputStream wrappedStream;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ComponentLocation originatingLocation;
    private ClosingCursorException closerResponsible;
    private final boolean trackCursorProviderClose;

    public AbstractCursorStreamProvider(InputStream wrappedStream, ComponentLocation originatingLocation, boolean trackCursorProviderClose) {
        this.wrappedStream = wrappedStream;
        this.originatingLocation = originatingLocation;
        this.trackCursorProviderClose = trackCursorProviderClose;
    }

    @Deprecated
    public AbstractCursorStreamProvider(InputStream wrappedStream) {
        this(wrappedStream, null, false);
    }

    @Override
    public final CursorStream openCursor() {
        if (this.closed.get()) {
            throw new CursorProviderAlreadyClosedException("Cannot open a new cursor on a closed stream", this.getOriginatingLocation(), Optional.ofNullable(this.closerResponsible));
        }
        return this.doOpenCursor();
    }

    @Override
    public void close() {
        this.closed.set(true);
        if (this.trackCursorProviderClose) {
            this.closerResponsible = new ClosingCursorException("Responsible for closing the stream.");
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    protected abstract CursorStream doOpenCursor();

    @Override
    public Optional<ComponentLocation> getOriginatingLocation() {
        return Optional.ofNullable(this.originatingLocation);
    }
}

