/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.function;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcherUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.util.Preconditions;

public class CausedByFunction
implements ExpressionFunction {
    private final ErrorTypeRepository errorTypeRepository;

    public CausedByFunction(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    @Override
    public Object call(Object[] parameters, BindingContext context) {
        Error error = (Error)parameters[0];
        Preconditions.checkArgument(error != null, "There's no error to match against.");
        String errorIdentifier = (String)parameters[1];
        ErrorTypeMatcher errorTypeMatcher = ErrorTypeMatcherUtils.createErrorTypeMatcher(this.resolveErrorType(errorIdentifier));
        return errorTypeMatcher.match(error.getErrorType());
    }

    private ErrorType resolveErrorType(String errorIdentifier) {
        return this.errorTypeRepository.getErrorType(ComponentIdentifier.buildFromStringRepresentation(errorIdentifier)).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find error type '%s'.", errorIdentifier)));
    }

    @Override
    public Optional<DataType> returnType() {
        return Optional.of(DataType.BOOLEAN);
    }

    @Override
    public List<FunctionParameter> parameters() {
        return Arrays.asList(new FunctionParameter("error", DataType.fromType(Error.class), context -> context.lookup("error").orElse(null)), new FunctionParameter("type", DataType.STRING));
    }
}

