/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;

public class FilteredErrorTypeRepository
implements ErrorTypeRepository {
    private final ErrorTypeRepository delegate;
    private final Set<String> filteredNamespaces;

    public FilteredErrorTypeRepository(ErrorTypeRepository delegate, Set<String> filteredNamespaces) {
        this.delegate = delegate;
        this.filteredNamespaces = filteredNamespaces;
    }

    @Override
    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        if (this.filteredNamespaces.contains(errorTypeComponentIdentifier.getNamespace().toUpperCase())) {
            return this.delegate.lookupErrorType(errorTypeComponentIdentifier);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        if (this.filteredNamespaces.contains(errorTypeIdentifier.getNamespace().toUpperCase())) {
            return this.delegate.getErrorType(errorTypeIdentifier);
        }
        return Optional.empty();
    }

    @Override
    public Collection<String> getErrorNamespaces() {
        return this.delegate.getErrorNamespaces().stream().filter(ns -> this.filteredNamespaces.contains(ns.toUpperCase())).collect(Collectors.toList());
    }

    @Override
    public ErrorType getAnyErrorType() {
        return this.delegate.getAnyErrorType();
    }

    @Override
    public ErrorType getSourceErrorType() {
        return this.delegate.getSourceErrorType();
    }

    @Override
    public ErrorType getSourceResponseErrorType() {
        return this.delegate.getSourceResponseErrorType();
    }

    @Override
    public ErrorType getCriticalErrorType() {
        return this.delegate.getCriticalErrorType();
    }

    @Override
    public Set<ErrorType> getErrorTypes() {
        return this.delegate.getErrorTypes().stream().filter(err -> this.filteredNamespaces.contains(err.getNamespace().toUpperCase())).collect(Collectors.toSet());
    }

    @Override
    public Set<ErrorType> getInternalErrorTypes() {
        return this.delegate.getInternalErrorTypes().stream().filter(err -> this.filteredNamespaces.contains(err.getNamespace().toUpperCase())).collect(Collectors.toSet());
    }
}

