/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.ExceptionRouter;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalErrorHandler
extends ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalErrorHandler.class);
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final AtomicInteger started = new AtomicInteger(0);
    private Map<Component, Consumer<Exception>> routers = new HashMap<Component, Consumer<Exception>>();

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        throw new IllegalStateException("GlobalErrorHandlers should be used only as template for local ErrorHandlers");
    }

    public Consumer<Exception> routerForChain(MessageProcessorChain chain, Supplier<Consumer<Exception>> errorRouterSupplier) {
        if (!this.routers.containsKey(chain)) {
            this.routers.put(chain, this.newGlobalRouter(errorRouterSupplier.get()));
        }
        return this.routers.get(chain);
    }

    private Consumer<Exception> newGlobalRouter(final Consumer<Exception> router) {
        return new ExceptionRouter(){
            final AtomicBoolean disposed = new AtomicBoolean(false);

            @Override
            public void accept(Exception error) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Routing error in '" + String.valueOf(this) + "'...");
                }
                router.accept(error);
            }

            @Override
            public void dispose() {
                if (!this.disposed.getAndSet(true)) {
                    LifecycleUtils.disposeIfNeeded(router, LOGGER);
                }
            }
        };
    }

    @Override
    public void initialise() throws InitialisationException {
        if (!this.initialised.getAndSet(true)) {
            super.initialise();
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.started.getAndIncrement() == 0) {
            super.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.started.decrementAndGet() == 0) {
            super.stop();
        }
    }

    @Override
    public void dispose() {
        if (this.started.get() == 0 && this.initialised.getAndSet(false)) {
            super.dispose();
        }
    }

    public void setFromGlobalErrorHandler() {
        this.getExceptionListeners().stream().filter(TemplateOnErrorHandler.class::isInstance).forEach(exceptionListener -> ((TemplateOnErrorHandler)exceptionListener).setFromGlobalErrorHandler(true));
    }

    @Override
    public Map<Component, Consumer<Exception>> getRouters() {
        return this.routers;
    }

    public void clearRouterForChain(MessageProcessorChain chain) {
        this.routers.remove(chain);
    }

    public void addComponentReference(ComponentLocation location) {
        this.getExceptionListeners().stream().filter(TemplateOnErrorHandler.class::isInstance).forEach(exceptionListener -> ((TemplateOnErrorHandler)exceptionListener).addGlobalErrorHandlerComponentReference(location));
    }

    public void addComponentReference(String name) {
        this.getExceptionListeners().stream().filter(TemplateOnErrorHandler.class::isInstance).forEach(exceptionListener -> ((TemplateOnErrorHandler)exceptionListener).addGlobalErrorHandlerComponentReference(name));
    }
}

