/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.lifecycle.AbstractLifecycleManager;

public class MuleContextLifecycleManager
extends AbstractLifecycleManager<MuleContext>
implements MuleContextAware {
    private MuleContext muleContext;
    private MuleContextLifecycleCallback callback = new MuleContextLifecycleCallback();

    public MuleContextLifecycleManager() {
        super("MuleContext", null);
    }

    @Override
    protected void registerTransitions() {
        this.addDirectTransition("not in lifecycle", "initialise");
        this.addDirectTransition("not in lifecycle", "dispose");
        this.addDirectTransition("initialise", "start");
        this.addDirectTransition("initialise", "dispose");
        this.addDirectTransition("start", "stop");
        this.addDirectTransition("stop", "start");
        this.addDirectTransition("stop", "dispose");
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.object = this.muleContext;
    }

    @Override
    public void fireLifecycle(String destinationPhase) throws LifecycleException {
        this.checkPhase(destinationPhase);
        this.invokePhase(destinationPhase, this.object, this.callback);
    }

    @Override
    protected void doOnConnectException(ConnectException ce) throws LifecycleException {
        throw new LifecycleException(ce, (Object)this);
    }

    class MuleContextLifecycleCallback
    implements LifecycleCallback<MuleContext> {
        MuleContextLifecycleCallback() {
        }

        @Override
        public void onTransition(String phaseName, MuleContext muleContext) throws MuleException {
            ((MuleContextWithRegistry)muleContext).getRegistry().fireLifecycle(phaseName);
        }
    }
}

