/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.message.ExceptionPayload;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.metadata.DefaultCollectionDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMessageBuilder
implements InternalMessage.Builder,
InternalMessage.PayloadBuilder,
InternalMessage.CollectionBuilder,
InternalMessage.MapBuilder {
    private static final TypedValue NULL_TYPED_VALUE = TypedValue.of(null);
    private TypedValue payload = TypedValue.of(NULL_TYPED_VALUE);
    private TypedValue attributes = TypedValue.of(NULL_TYPED_VALUE);

    public DefaultMessageBuilder() {
    }

    public DefaultMessageBuilder(Message message) {
        Objects.requireNonNull(message);
        this.payload = message.getPayload();
        this.attributes = message.getAttributes();
    }

    @Override
    public InternalMessage.Builder payload(TypedValue<?> payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public InternalMessage.Builder nullValue() {
        this.payload = new TypedValue<Object>(null, this.resolveDataType(null));
        return this;
    }

    @Override
    public InternalMessage.Builder value(Object value) {
        this.payload = new TypedValue<Object>(value, this.resolveDataType(value));
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder mediaType(MediaType mediaType) {
        this.payload = new TypedValue(this.payload.getValue(), DataType.builder(this.payload.getDataType()).mediaType(mediaType).build(), this.payload.getLength());
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder streamValue(Iterator payload, Class<?> clazz) {
        Objects.requireNonNull(payload);
        this.payload = new TypedValue<Iterator>(payload, DataType.builder().streamType(payload.getClass()).itemType(clazz).build());
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder collectionValue(Collection payload, Class<?> clazz) {
        Objects.requireNonNull(payload);
        this.payload = new TypedValue<Collection>(payload, DataType.builder().collectionType(payload.getClass()).itemType(clazz).build());
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder collectionValue(Object[] payload) {
        Objects.requireNonNull(payload);
        return this.collectionValue((Collection)Arrays.asList(payload), (Class)payload.getClass().getComponentType());
    }

    @Override
    public InternalMessage.MapBuilder mapValue(Map payload, Class<?> keyType, Class<?> valueType) {
        Objects.requireNonNull(payload);
        this.payload = new TypedValue<Map>(payload, DataType.builder().mapType(payload.getClass()).keyType(keyType).valueType(valueType).build());
        return this;
    }

    @Override
    public Message.MapBuilder valueMediaType(MediaType mediaType) {
        if (!(this.payload.getDataType() instanceof MapDataType)) {
            throw new IllegalStateException("Value MediaType cannot be set, because payload is not a map");
        }
        this.payload = new TypedValue(this.payload.getValue(), ((DataTypeBuilder.DataTypeMapTypeBuilder)((Object)DataType.builder(this.payload.getDataType()))).valueMediaType(mediaType).build());
        return this;
    }

    @Override
    public Message.MapBuilder keyMediaType(MediaType mediaType) {
        if (!(this.payload.getDataType() instanceof MapDataType)) {
            throw new IllegalStateException("Key MediaType cannot be set, because payload is not a map");
        }
        this.payload = new TypedValue(this.payload.getValue(), ((DataTypeBuilder.DataTypeMapTypeBuilder)((Object)DataType.builder(this.payload.getDataType()))).keyMediaType(mediaType).build());
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder itemMediaType(MediaType mediaType) {
        if (!(this.payload.getDataType() instanceof DefaultCollectionDataType)) {
            throw new IllegalStateException("Item MediaType cannot be set, because payload is not a collection");
        }
        this.payload = new TypedValue(this.payload.getValue(), ((DataTypeBuilder.DataTypeCollectionTypeBuilder)((Object)DataType.builder(this.payload.getDataType()))).itemMediaType(mediaType).build());
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder attributes(TypedValue<?> attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder nullAttributesValue() {
        this.attributes = new TypedValue<Object>(null, this.resolveAttributesDataType(null));
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder attributesValue(Object value) {
        this.attributes = new TypedValue<Object>(value, this.resolveAttributesDataType(value));
        return this;
    }

    @Override
    public InternalMessage.CollectionBuilder attributesMediaType(MediaType mediaType) {
        this.attributes = new TypedValue(this.attributes.getValue(), DataType.builder(this.attributes.getDataType()).mediaType(mediaType).build(), this.attributes.getLength());
        return this;
    }

    @Override
    @Deprecated
    public InternalMessage.CollectionBuilder exceptionPayload(ExceptionPayload exceptionPayload) {
        return this;
    }

    @Override
    public InternalMessage build() {
        return new MessageImplementation(this.payload, this.attributes);
    }

    private DataType resolveDataType(Object value) {
        if (this.payload == null) {
            return DataType.fromObject(value);
        }
        return DataType.builder(this.payload.getDataType()).fromObject(value).build();
    }

    private DataType resolveAttributesDataType(Object value) {
        if (this.attributes == null) {
            return DataType.fromObject(value);
        }
        return DataType.builder(this.attributes.getDataType()).fromObject(value).build();
    }

    public static Class getMessageImplementationClass() {
        return MessageImplementation.class;
    }

    public static class MessageImplementation
    implements InternalMessage {
        private static final String NOT_SET = "<not set>";
        private static final long serialVersionUID = 1541720810851984845L;
        private static final Logger logger = LoggerFactory.getLogger(MessageImplementation.class);
        private transient TypedValue typedValue;
        private final TypedValue typedAttributes;
        private final Map<String, TypedValue<Serializable>> inboundMap = null;
        private final Map<String, TypedValue<Serializable>> outboundMap = null;

        private MessageImplementation(TypedValue typedValue, TypedValue typedAttributes) {
            this.typedValue = typedValue;
            this.typedAttributes = typedAttributes;
        }

        @Override
        public ExceptionPayload getExceptionPayload() {
            return null;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(120);
            buf.append(System.lineSeparator());
            buf.append(this.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("{");
            buf.append(System.lineSeparator());
            buf.append("  payload=").append(ObjectUtils.defaultIfNull(this.getPayload().getValue(), (Object)NOT_SET));
            buf.append(System.lineSeparator());
            buf.append("  mediaType=").append(this.getPayload().getDataType().getMediaType());
            buf.append(System.lineSeparator());
            buf.append("  attributes=").append(ObjectUtils.defaultIfNull(this.getAttributes().getValue(), (Object)NOT_SET));
            buf.append(System.lineSeparator());
            buf.append("  attributesMediaType=").append(this.getAttributes().getDataType().getMediaType());
            buf.append(System.lineSeparator());
            buf.append('}');
            return buf.toString();
        }

        public TypedValue getPayload() {
            return this.typedValue;
        }

        private void writeObject(ObjectOutputStream out) throws Exception {
            out.defaultWriteObject();
            this.serializeValue(out);
            out.writeObject(null);
            out.writeObject(null);
        }

        protected void serializeValue(ObjectOutputStream out) throws Exception {
            if (this.typedValue.getValue() == null || this.typedValue.getValue() instanceof Serializable) {
                out.writeBoolean(true);
                out.writeObject(this.typedValue.getValue());
                out.writeObject(this.typedValue.getDataType());
            } else {
                out.writeBoolean(false);
                if (DefaultMuleContext.currentMuleContext.get() != null) {
                    byte[] valueAsByteArray = (byte[])DefaultMuleContext.currentMuleContext.get().getTransformationService().transform(this, DataType.BYTE_ARRAY).getPayload().getValue();
                    out.writeInt(valueAsByteArray.length);
                    new DataOutputStream(out).write(valueAsByteArray);
                    out.writeObject(DataType.builder(DataType.BYTE_ARRAY).mediaType(this.typedValue.getDataType().getMediaType()).build());
                } else {
                    throw new NotSerializableException(this.typedValue.getDataType().getType().getName());
                }
            }
        }

        protected Object deserializeValue(ObjectInputStream in) throws Exception {
            if (in.readBoolean()) {
                return in.readObject();
            }
            int length = in.readInt();
            byte[] valueAsByteArray = new byte[length];
            new DataInputStream(in).readFully(valueAsByteArray);
            return valueAsByteArray;
        }

        private void readObject(ObjectInputStream in) throws Exception {
            in.defaultReadObject();
            this.typedValue = new TypedValue<Object>(this.deserializeValue(in), (DataType)in.readObject());
            in.readObject();
            in.readObject();
        }

        public TypedValue getAttributes() {
            return this.typedAttributes;
        }
    }
}

