/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Consumer;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.PolicyNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;

public class PolicyNotificationHelper {
    private ServerNotificationHandler notificationHandler;
    private String policyId;
    private Component component;

    public PolicyNotificationHelper(ServerNotificationHandler notificationHandler, String policyId, Component component) {
        this.notificationHandler = notificationHandler;
        this.policyId = policyId;
        this.component = component;
    }

    public Consumer<CoreEvent> notification(int action) {
        return event -> this.fireNotification((CoreEvent)event, null, action);
    }

    public void fireNotification(CoreEvent event, Exception e, int action) {
        if (this.notificationHandler != null && event != null && this.notificationHandler.isNotificationEnabled(PolicyNotification.class)) {
            this.notificationHandler.fireNotification(this.createNotification(event, e, action));
        }
    }

    private PolicyNotification createNotification(CoreEvent event, Exception e, int action) {
        EnrichedNotificationInfo info = EnrichedNotificationInfo.createInfo(event, e, this.component);
        return new PolicyNotification(this.policyId, info, action, this.component.getLocation());
    }
}

