/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.processor.interceptor.ComponentInterceptorAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptionAction;

class ProcessorInterceptorWrapper
implements ComponentInterceptorAdapter {
    private static final String BEFORE_METHOD_NAME = "before";
    private static final String AFTER_METHOD_NAME = "after";
    private static final String AROUND_METHOD_NAME = "around";
    private final ProcessorInterceptor processorInterceptor;

    public ProcessorInterceptorWrapper(ProcessorInterceptor processorInterceptor) {
        this.processorInterceptor = processorInterceptor;
    }

    @Override
    public boolean implementsBeforeOrAfter() {
        try {
            return !this.processorInterceptor.getClass().getMethod(BEFORE_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class).isDefault() || !this.processorInterceptor.getClass().getMethod(AFTER_METHOD_NAME, ComponentLocation.class, InterceptionEvent.class, Optional.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean implementsAround() {
        try {
            return !this.processorInterceptor.getClass().getMethod(AROUND_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class, InterceptionAction.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> resolvedParams, DefaultInterceptionEvent interceptionEvent) {
        this.processorInterceptor.before(location, resolvedParams, interceptionEvent);
    }

    @Override
    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> resolvedParams, DefaultInterceptionEvent interceptionEvent, ReactiveInterceptionAction reactiveInterceptionAction) {
        return this.processorInterceptor.around(location, resolvedParams, interceptionEvent, reactiveInterceptionAction);
    }

    @Override
    public void after(ComponentLocation location, DefaultInterceptionEvent interceptionEvent, Optional<Throwable> thrown) {
        this.processorInterceptor.after(location, interceptionEvent, thrown);
    }

    @Override
    public boolean isErrorMappingRequired(ComponentLocation location) {
        return this.processorInterceptor.isErrorMappingRequired(location);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.processorInterceptor.getClass().getClassLoader();
    }
}

