/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;

public class SetPayloadMessageProcessor
extends SimpleMessageProcessor {
    private static final TypedValue NULL_TYPED_VALUE = new TypedValue<Object>(null, DataType.OBJECT);
    private ExtendedExpressionManager expressionManager;
    private DataType dataType;
    private String value;
    private AttributeEvaluator valueEvaluator;

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        Message.Builder builder = Message.builder(event.getMessage());
        CoreEvent.Builder eventBuilder = CoreEvent.builder(event);
        if (this.dataType == null) {
            TypedValue typedValue = this.resolveTypedValue(event);
            builder.value(typedValue.getValue()).mediaType(typedValue.getDataType().getMediaType());
        } else {
            Object value = this.resolveValue(event);
            DataTypeParamsBuilder dataTypeBuilder = DataType.builder(this.dataType).type(value == null ? Object.class : value.getClass());
            builder.value(value).mediaType(dataTypeBuilder.build().getMediaType());
        }
        return eventBuilder.message(builder.build()).build();
    }

    private Object resolveValue(CoreEvent event) {
        Object value = this.valueEvaluator.getRawValue() == null ? null : this.valueEvaluator.resolveValue(event);
        return value;
    }

    private TypedValue resolveTypedValue(CoreEvent event) {
        if (this.valueEvaluator.getRawValue() == null) {
            return NULL_TYPED_VALUE;
        }
        return this.valueEvaluator.resolveTypedValue(event);
    }

    public void setMimeType(String mimeType) {
        this.setDataType(DataType.builder(this.dataType == null ? DataType.OBJECT : this.dataType).mediaType(MediaType.parseDefinedInApp(mimeType)).build());
    }

    public void setEncoding(String encoding) {
        this.setDataType(DataType.builder(this.dataType == null ? DataType.OBJECT : this.dataType).charset(encoding).build());
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType.getMediaType().getCharset().isPresent() ? dataType : DataType.builder(dataType).build();
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.valueEvaluator = new AttributeEvaluator(this.value, this.dataType);
        this.valueEvaluator.initialize(this.expressionManager);
    }

    @Inject
    public void setExpressionManager(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

