/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.profiling.ProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.threading.ThreadSnapshotCollector;
import org.mule.runtime.api.profiling.tracing.ExecutionContext;
import org.mule.runtime.api.profiling.tracing.TracingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.AbstractProfilingService;
import org.mule.runtime.core.internal.profiling.ArtifactProfilingProducerScope;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducerDelegate;
import org.mule.runtime.core.internal.profiling.discovery.CompositeProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.core.internal.profiling.discovery.DefaultProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.core.internal.profiling.producer.provider.ProfilingDataProducerResolver;
import org.mule.runtime.core.internal.profiling.threading.JvmThreadSnapshotCollector;
import org.mule.runtime.core.internal.profiling.tracing.ThreadLocalTracingService;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultProfilingService
extends AbstractProfilingService {
    @Inject
    private ProfilingFeatureFlaggingService featureFlaggingService;
    @Inject
    private EventTracer<CoreEvent> eventTracer;
    private Optional<Set<ProfilingDataConsumerDiscoveryStrategy>> profilingDataConsumerDiscoveryStrategies = Optional.empty();
    private final TracingService tracingService = new ThreadLocalTracingService();
    private final ThreadSnapshotCollector threadSnapshotCollector = new JvmThreadSnapshotCollector();
    private ProfilingDataProducerResolver profilingDataProducerResolver;
    private final Map<ProfilingEventType<?>, Map<ProfilingProducerScope, ResettableProfilingDataProducer<?, ?>>> profilingDataProducers = new ConcurrentHashMap();

    @Override
    public <T extends ProfilingEventContext, S> void registerProfilingDataProducer(ProfilingEventType<T> profilingEventType, ProfilingDataProducer<T, S> profilingDataProducer) {
        this.profilingDataProducers.computeIfAbsent(profilingEventType, profEventType -> new ConcurrentHashMap()).put(new ArtifactProfilingProducerScope(this.getScope()), new ResettableProfilingDataProducerDelegate<T, S>(profilingDataProducer, profDataProducer -> {
            if (profDataProducer instanceof ResettableProfilingDataProducer) {
                ((ResettableProfilingDataProducer)profDataProducer).reset();
            }
        }));
    }

    @Override
    public void initialise() throws InitialisationException {
        this.initialiseProfilingDataProducerIfNeeded();
        super.initialise();
    }

    @Override
    protected void onDataConsumersRegistered() {
        this.profilingDataProducers.values().forEach(producers -> producers.values().forEach(ResettableProfilingDataProducer::reset));
    }

    @Override
    public ThreadSnapshotCollector getThreadSnapshotCollector() {
        return this.threadSnapshotCollector;
    }

    @Override
    public TracingService getTracingService() {
        return this.tracingService;
    }

    @Override
    public <T extends ProfilingEventContext, S> ProfilingDataProducer<T, S> getProfilingDataProducer(ProfilingEventType<T> profilingEventType) {
        return this.getProfilingDataProducer(profilingEventType, new ArtifactProfilingProducerScope(this.getScope()));
    }

    @Override
    public <T extends ProfilingEventContext, S> ProfilingDataProducer<T, S> getProfilingDataProducer(ProfilingEventType<T> profilingEventType, ProfilingProducerScope profilingProducerScope) {
        this.initialiseProfilingDataProducerIfNeeded();
        return this.profilingDataProducers.computeIfAbsent(profilingEventType, profEventType -> new ConcurrentHashMap()).computeIfAbsent(profilingProducerScope, profilingProdScope -> this.profilingDataProducerResolver.getProfilingDataProducer(profilingEventType, profilingProducerScope));
    }

    private void initialiseProfilingDataProducerIfNeeded() {
        if (this.profilingDataProducerResolver == null) {
            this.profilingDataProducerResolver = new ProfilingDataProducerResolver(this, this.threadSnapshotCollector, this.featureFlaggingService);
        }
    }

    @Override
    public ProfilingDataConsumerDiscoveryStrategy getDiscoveryStrategy() {
        HashSet<ProfilingDataConsumerDiscoveryStrategy> discoveryStrategies = new HashSet<ProfilingDataConsumerDiscoveryStrategy>();
        discoveryStrategies.add(new DefaultProfilingDataConsumerDiscoveryStrategy(this));
        this.profilingDataConsumerDiscoveryStrategies.ifPresent(discoveryStrategies::addAll);
        return new CompositeProfilingDataConsumerDiscoveryStrategy(discoveryStrategies);
    }

    @Inject
    public void setProfilingDataConsumerDiscoveryStrategies(Optional<Set<ProfilingDataConsumerDiscoveryStrategy>> profilingDataConsumerDiscoveryStrategies) {
        this.profilingDataConsumerDiscoveryStrategies = profilingDataConsumerDiscoveryStrategies;
    }

    @Override
    public <T extends ProfilingEventContext, S> Mono<S> enrichWithProfilingEventMono(Mono<S> original, ProfilingDataProducer<T, S> dataProducer, Function<S, T> transformer) {
        return original.doOnNext(s -> dataProducer.triggerProfilingEvent(s, transformer));
    }

    @Override
    public <T extends ProfilingEventContext, S> Flux<S> enrichWithProfilingEventFlux(Flux<S> original, ProfilingDataProducer<T, S> dataProducer, Function<S, T> transformer) {
        return original.doOnNext(s -> dataProducer.triggerProfilingEvent(s, transformer));
    }

    @Override
    public <S> Mono<S> setCurrentExecutionContext(Mono<S> original, Function<S, ExecutionContext> executionContextSupplier) {
        return original.doOnNext(s -> this.getTracingService().setCurrentExecutionContext((ExecutionContext)executionContextSupplier.apply(s)));
    }

    @Override
    public <S> Flux<S> setCurrentExecutionContext(Flux<S> original, Function<S, ExecutionContext> executionContextSupplier) {
        return original.doOnNext(s -> this.getTracingService().setCurrentExecutionContext((ExecutionContext)executionContextSupplier.apply(s)));
    }

    @Override
    public EventTracer<CoreEvent> getCoreEventTracer() {
        return this.eventTracer;
    }

    private String getScope() {
        if (this.muleContext == null) {
            return "";
        }
        return ProfilingUtils.getArtifactId(this.muleContext);
    }

    @Override
    public void injectDistributedTraceContext(EventContext eventContext, DistributedTraceContextGetter distributedTraceContextGetter) {
        this.eventTracer.injectDistributedTraceContext(eventContext, distributedTraceContextGetter);
    }

    @Override
    public SpanSnifferManager getSpanExportManager() {
        return this.eventTracer.getSpanSnifferManager();
    }
}

