/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.consumer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.profiling.consumer.annotations.RuntimeInternalProfilingDataConsumer;
import org.mule.runtime.core.internal.profiling.consumer.tracing.operations.LoggerProfilingEventOperation;
import org.mule.runtime.core.internal.profiling.consumer.tracing.operations.ProfilingExecutionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeInternalProfilingDataConsumer
public class ComponentProcessingStrategyDataConsumer
implements ProfilingDataConsumer<ComponentProcessingStrategyProfilingEventContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentProcessingStrategyDataConsumer.class);
    private final ImmutableMultimap<ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>, ProfilingExecutionOperation<ComponentProcessingStrategyProfilingEventContext>> operations;
    private final Logger customLogger;

    public ComponentProcessingStrategyDataConsumer(InternalProfilingService profilingService) {
        this(profilingService, LOGGER);
    }

    public ComponentProcessingStrategyDataConsumer(InternalProfilingService profilingService, Logger customLogger) {
        this.customLogger = customLogger;
        this.operations = ImmutableMultimap.builder().put(RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION, (Object)new LoggerProfilingEventOperation(customLogger, RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION)).put(RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION, (Object)new LoggerProfilingEventOperation(customLogger, RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION)).put(RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED, (Object)new LoggerProfilingEventOperation(customLogger, RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED)).put(RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING, (Object)new LoggerProfilingEventOperation(customLogger, RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING)).put(RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION, (Object)new LoggerProfilingEventOperation(customLogger, RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION)).put(RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION, (Object)new LoggerProfilingEventOperation(customLogger, RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION)).put(RuntimeProfilingEventTypes.FLOW_EXECUTED, (Object)new LoggerProfilingEventOperation(customLogger, RuntimeProfilingEventTypes.FLOW_EXECUTED)).build();
    }

    @Override
    public void onProfilingEvent(ProfilingEventType<ComponentProcessingStrategyProfilingEventContext> profilingEventType, ComponentProcessingStrategyProfilingEventContext profilingEventContext) {
        this.operations.get(profilingEventType).forEach(operation -> operation.execute(profilingEventContext));
    }

    @Override
    public Set<ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>> getProfilingEventTypes() {
        return ImmutableSet.of(RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION, RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION, RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED, RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING, RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION, RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION, (Object[])new ProfilingEventType[]{RuntimeProfilingEventTypes.FLOW_EXECUTED});
    }

    @Override
    public Predicate<ComponentProcessingStrategyProfilingEventContext> getEventContextFilter() {
        return processingStrategyProfilingEventContext -> true;
    }

    protected Logger getDataConsumerLogger() {
        return this.customLogger;
    }
}

