/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import java.io.IOException;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.Preconditions;

public abstract class AbstractCursorIterator<T>
implements CursorIterator<T> {
    private final CursorIteratorProvider provider;
    private boolean released = false;
    private boolean closed = false;
    private long position = 0L;

    public AbstractCursorIterator(CursorIteratorProvider provider) {
        Preconditions.checkArgument(provider != null, "provider cannot be null");
        this.provider = provider;
    }

    protected abstract T doNext(long var1);

    @Override
    public final T next() {
        this.assertNotClosed();
        T item = this.doNext(this.position);
        ++this.position;
        return item;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void seek(long position) throws IOException {
        this.assertNotClosed();
        this.position = position;
    }

    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.doClose();
        }
    }

    protected abstract void doClose() throws IOException;

    @Override
    public boolean isReleased() {
        return this.released;
    }

    @Override
    public CursorIteratorProvider getProvider() {
        return this.provider;
    }

    protected void assertNotClosed() {
        Preconditions.checkState(!this.released, "Stream is closed");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing from a stream is not supported");
    }
}

