/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.io.IOException;
import java.util.List;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.AbstractCursorIterator;

public class ListCursorIterator<T>
extends AbstractCursorIterator<T> {
    private List<T> items;

    public ListCursorIterator(CursorIteratorProvider provider, List<T> items) {
        super(provider);
        this.items = items;
    }

    @Override
    protected T doNext(long position) {
        return this.items.get(Math.toIntExact(position));
    }

    @Override
    protected void doClose() throws IOException {
        this.items = null;
    }

    @Override
    public boolean hasNext() {
        return this.getPosition() < (long)this.items.size();
    }

    @Override
    public void release() {
        this.items = null;
    }

    @Override
    public int getSize() {
        return this.items.size();
    }
}

