/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.io.IOException;
import java.util.function.Consumer;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;
import org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider;

class ManagedCursorIterator<T>
implements CursorIterator<T> {
    private ManagedCursorIteratorProvider managedCursorIteratorProvider;
    private CursorIteratorProvider exposedProvider;
    private final CursorIterator<T> delegate;
    private final CursorProviderJanitor janitor;

    ManagedCursorIterator(ManagedCursorIteratorProvider managedCursorIteratorProvider, CursorIterator<T> delegate, CursorProviderJanitor janitor) {
        this.managedCursorIteratorProvider = managedCursorIteratorProvider;
        this.exposedProvider = managedCursorIteratorProvider;
        this.delegate = delegate;
        this.janitor = janitor;
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            if (this.managedCursorIteratorProvider != null) {
                this.exposedProvider = (CursorIteratorProvider)this.managedCursorIteratorProvider.getDelegate();
                this.managedCursorIteratorProvider = null;
            }
            this.janitor.releaseCursor(this.delegate);
        }
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return (T)this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.delegate.forEachRemaining(action);
    }

    @Override
    public long getPosition() {
        return this.delegate.getPosition();
    }

    @Override
    public void seek(long position) throws IOException {
        this.delegate.seek(position);
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public boolean isReleased() {
        return this.delegate.isReleased();
    }

    @Override
    public CursorProvider getProvider() {
        return this.exposedProvider;
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }
}

