/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.registry.TransformerWeighting;
import org.mule.runtime.core.internal.transformer.graph.ConverterFilter;

public class PriorityWeightingConverterFilter
implements ConverterFilter {
    @Override
    public List<Converter> filter(List<Converter> converters, DataType source, DataType result) {
        if (converters.size() == 0) {
            return Collections.emptyList();
        }
        List<TransformerWeighting> weightings = this.getTransformerWeightings(converters, source.getType(), result.getType());
        TransformerWeighting transformerWeighting = weightings.get(weightings.size() - 1);
        LinkedList<Converter> heaviestConverter = new LinkedList<Converter>();
        heaviestConverter.add((Converter)transformerWeighting.getTransformer());
        for (int index = weightings.size() - 2; index > -1 && weightings.get(index).compareTo(transformerWeighting) >= 0; --index) {
            heaviestConverter.add((Converter)weightings.get(index).getTransformer());
        }
        return heaviestConverter;
    }

    private List<TransformerWeighting> getTransformerWeightings(List<Converter> converters, Class input, Class output) {
        LinkedList<TransformerWeighting> weightings = new LinkedList<TransformerWeighting>();
        for (Converter converter : converters) {
            TransformerWeighting current = new TransformerWeighting(input, output, converter);
            weightings.add(current);
        }
        Collections.sort(weightings);
        return weightings;
    }
}

