/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.File;
import java.io.IOException;

public final class MuleContainerUtils {
    public static final String MULE_DOMAIN_FOLDER = "domains";
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";
    private static final String MULE_APPS_FILENAME = "apps";
    private static final String MULE_LIB_FILENAME = "lib/mule";
    private static final String MULE_CONF_FILENAME = "conf";

    private MuleContainerUtils() {
    }

    public static boolean isStandalone() {
        return MuleContainerUtils.getMuleHome() != null;
    }

    public static File getMuleHome() {
        String muleHome = System.getProperty("mule.home");
        return muleHome != null ? new File(muleHome) : null;
    }

    public static File getMuleBase() {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            try {
                muleBase = new File(muleBaseVar).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (muleBase == null) {
            muleBase = MuleContainerUtils.getMuleHome();
        }
        return muleBase;
    }

    public static File getMuleAppsDir() {
        return MuleContainerUtils.isStandalone() ? new File(MuleContainerUtils.getMuleBase(), MULE_APPS_FILENAME) : null;
    }

    public static File getMuleLibDir() {
        return MuleContainerUtils.isStandalone() ? new File(MuleContainerUtils.getMuleHome(), MULE_LIB_FILENAME) : null;
    }

    public static File getMuleDomainsDir() {
        return MuleContainerUtils.isStandalone() ? new File(MuleContainerUtils.getMuleBase(), MULE_DOMAIN_FOLDER) : null;
    }

    public static File getMuleConfDir() {
        return MuleContainerUtils.isStandalone() ? new File(MuleContainerUtils.getMuleBase(), MULE_CONF_FILENAME) : null;
    }
}

