/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.metadata;

import java.util.Objects;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;

@NoExtend
public class SimpleDataType
implements DataType {
    private static final long serialVersionUID = -4590745924720880358L;
    protected final Class<?> type;
    protected final MediaType mimeType;
    protected final boolean streamType;

    protected SimpleDataType(Class<?> type, MediaType mimeType, boolean streamType) {
        this.type = type;
        this.mimeType = mimeType;
        this.streamType = streamType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public MediaType getMediaType() {
        return this.mimeType;
    }

    private Class<?> fromPrimitive(Class<?> type) {
        Class<?> primitiveWrapper = this.getPrimitiveWrapper(type);
        if (primitiveWrapper != null) {
            return primitiveWrapper;
        }
        return type;
    }

    private Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof DataType.DynamicDelegateDataType) {
            o = ((DataType.DynamicDelegateDataType)o).getDelegate();
        }
        if (this == o) {
            return true;
        }
        if (o == null || !this.equalsCheckClass(o)) {
            return false;
        }
        SimpleDataType that = (SimpleDataType)o;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getMediaType(), that.getMediaType());
    }

    protected boolean equalsCheckClass(Object o) {
        return this.getClass() == o.getClass() || SimpleDataType.class.isAssignableFrom(o.getClass());
    }

    @Override
    public boolean isCompatibleWith(DataType dataType) {
        if (dataType instanceof DataType.DynamicDelegateDataType) {
            dataType = ((DataType.DynamicDelegateDataType)dataType).getDelegate();
        }
        if (this == dataType) {
            return true;
        }
        if (dataType == null) {
            return false;
        }
        SimpleDataType that = (SimpleDataType)dataType;
        if (!this.fromPrimitive(this.getType()).isAssignableFrom(this.fromPrimitive(that.getType()))) {
            return false;
        }
        return MediaType.ANY.matches(this.getMediaType()) || this.mediaTypesMatch(dataType);
    }

    private boolean mediaTypesMatch(DataType other) {
        if (this.getMediaType() == null && other.getMediaType() != null) {
            return false;
        }
        if (this.getMediaType() != null && other.getMediaType() == null) {
            return false;
        }
        if (!this.getMediaType().getCharset().isPresent()) {
            return this.getMediaType().matches(other.getMediaType());
        }
        return this.getMediaType().equals(other.getMediaType());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getMediaType());
    }

    public String toString() {
        return "SimpleDataType{type=" + (this.type == null ? null : this.type.getName()) + ", mimeType='" + String.valueOf(this.mimeType) + "'}";
    }

    @Override
    public boolean isStreamType() {
        return this.streamType;
    }
}

