/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.simple;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.WildcardAttributeEvaluator;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoveVariablePropertyProcessor
extends SimpleMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRemoveVariablePropertyProcessor.class);
    private ExtendedExpressionManager expressionManager;
    private AttributeEvaluator identifierEvaluator;
    private WildcardAttributeEvaluator wildcardAttributeEvaluator;

    @Override
    public void initialise() throws InitialisationException {
        this.identifierEvaluator.initialize(this.expressionManager);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        if (this.wildcardAttributeEvaluator.hasWildcards()) {
            AtomicReference<CoreEvent> resultEvent = new AtomicReference<CoreEvent>(event);
            this.wildcardAttributeEvaluator.processValues(this.getPropertyNames((PrivilegedEvent)event), matchedValue -> {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Removing property: '%s' from scope: '%s'", matchedValue, this.getScopeName()));
                }
                resultEvent.set(this.removeProperty((PrivilegedEvent)event, matchedValue));
            });
            return resultEvent.get();
        }
        String key = (String)this.identifierEvaluator.resolveValue(event);
        if (key != null) {
            return this.removeProperty((PrivilegedEvent)event, key);
        }
        logger.info("Key expression return null, no property will be removed");
        return event;
    }

    protected abstract Set<String> getPropertyNames(PrivilegedEvent var1);

    protected abstract PrivilegedEvent removeProperty(PrivilegedEvent var1, String var2);

    public Object clone() throws CloneNotSupportedException {
        AbstractRemoveVariablePropertyProcessor clone = (AbstractRemoveVariablePropertyProcessor)super.clone();
        clone.setIdentifier(this.identifierEvaluator.getRawValue());
        return clone;
    }

    public void setIdentifier(String identifier) {
        if (StringUtils.isBlank(identifier)) {
            throw new IllegalArgumentException("Remove with null identifier is not supported");
        }
        this.identifierEvaluator = new AttributeEvaluator(identifier, DataType.STRING);
        this.wildcardAttributeEvaluator = new WildcardAttributeEvaluator(identifier);
    }

    protected abstract String getScopeName();

    @Inject
    public void setExpressionManager(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

