/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import org.mule.apache.xerces.parsers.XMLGrammarPreparser;
import org.mule.apache.xerces.util.XMLGrammarPoolImpl;
import org.mule.apache.xerces.xni.grammars.Grammar;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.apache.xerces.xni.parser.XMLEntityResolver;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.runtime.dsl.internal.xerces.xni.parser.ReadOnlyXmlGrammarPool;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlGathererErrorHandler;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlGrammarPoolBuilder;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlSchemaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXmlGrammarPoolBuilder
implements XmlGrammarPoolBuilder {
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultXmlGrammarPoolBuilder.class);
    private final XmlSchemaProvider schemaProvider;
    private final XmlGathererErrorHandler errorHandler;
    private final XMLEntityResolver entityResolver;

    public DefaultXmlGrammarPoolBuilder(XmlSchemaProvider schemaProvider, XmlGathererErrorHandler errorHandler, XMLEntityResolver entityResolver) {
        this.schemaProvider = schemaProvider;
        this.errorHandler = errorHandler;
        this.entityResolver = entityResolver;
    }

    @Override
    public XMLGrammarPool build() {
        return new ReadOnlyXmlGrammarPool(this.buildCoreGrammarPool());
    }

    private XMLGrammarPool buildCoreGrammarPool() {
        XMLGrammarPool pool;
        try {
            pool = new XMLGrammarPoolImpl();
            XMLGrammarPreparser preparser = new XMLGrammarPreparser();
            preparser.setGrammarPool(pool);
            preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
            preparser.setFeature(NAMESPACES_FEATURE_ID, true);
            preparser.setFeature(VALIDATION_FEATURE_ID, true);
            preparser.setErrorHandler(this.errorHandler);
            preparser.setEntityResolver(this.entityResolver);
            for (XMLInputSource is : this.schemaProvider.getSchemas()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Preparsing grammar publicId: {}; systemId: {}...", (Object)is.getPublicId(), (Object)is.getSystemId());
                }
                preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", is);
            }
            if (this.errorHandler.getErrors().isEmpty()) {
                Grammar[] grammars = pool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
                LOGGER.debug("Loaded {} grammars", (Object)grammars.length);
            } else {
                String subMessage = String.format(this.errorHandler.getErrors().size() == 1 ? "was '%s' error" : "were '%s' errors", this.errorHandler.getErrors().size());
                StringBuilder sb = new StringBuilder("There " + subMessage + " while creating XMLSchemaGrammarPool. Using empty XMLGrammarPool");
                sb.append(System.lineSeparator()).append("Full list:");
                this.errorHandler.getErrors().forEach(error -> sb.append(System.lineSeparator()).append(error));
                sb.append(System.lineSeparator());
                LOGGER.warn(sb.toString());
                pool = DefaultXmlGrammarPoolBuilder.buildEmptyXMLGrammarPool();
            }
            pool.lockPool();
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to create grammar pool. Using empty XMLGrammarPool", e);
            pool = DefaultXmlGrammarPoolBuilder.buildEmptyXMLGrammarPool();
        }
        return pool;
    }

    public static XMLGrammarPool buildEmptyXMLGrammarPool() {
        XMLGrammarPoolImpl pool = new XMLGrammarPoolImpl(1);
        pool.lockPool();
        return pool;
    }
}

