/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.mule.runtime.dsl.internal.SourcePosition;
import org.mule.runtime.dsl.internal.xml.parser.DefaultXmlMetadataAnnotations;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotationsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class MuleDocumentLoader {
    private static final String MULE_DOCUMENT_BUILDER_FACTORY = "org.mule.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static final String SCHEMA_AUGMENT_PSVI_FEATURE = "http://apache.org/xml/features/validation/schema/augment-psvi";
    private static final UserDataHandler COPY_METADATA_ANNOTATIONS_DATA_HANDLER = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (operation == 2 || operation == 1) {
                dst.setUserData("metadataAnnotations", src.getUserData("metadataAnnotations"), this);
            }
        }
    };
    private final XmlMetadataAnnotationsFactory metadataFactory = new DefaultXmlMetadataFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document loadDocument(Supplier<SAXParserFactory> saxParserFactorySupplier, InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware, XMLGrammarPool xmlGrammarPool) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(MuleImplementationLoaderUtils.getMuleImplementationsLoader());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (InputStream inputStream = inputSource.getByteStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
            }
            InputSource defaultInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
            InputSource enrichInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
            DocumentBuilderFactory factory = this.createDocumentBuilderFactory(validationMode, namespaceAware, xmlGrammarPool);
            DocumentBuilder builder = this.createDocumentBuilder(factory, entityResolver, errorHandler);
            Document doc = builder.parse(defaultInputSource);
            this.createSaxAnnotator(saxParserFactorySupplier, doc).parse(enrichInputSource);
            Document document = doc;
            return document;
        }
        finally {
            thread.setContextClassLoader(currentClassLoader);
        }
    }

    protected XMLReader createSaxAnnotator(Supplier<SAXParserFactory> saxParserFactorySupplier, Document doc) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = saxParserFactorySupplier.get();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader documentReader = saxParser.getXMLReader();
        documentReader.setFeature(SCHEMA_AUGMENT_PSVI_FEATURE, false);
        documentReader.setContentHandler(new XmlMetadataAnnotator(doc, this.metadataFactory));
        return documentReader;
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory(int validationMode, boolean namespaceAware, XMLGrammarPool grammarPool) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(MULE_DOCUMENT_BUILDER_FACTORY, MuleImplementationLoaderUtils.getMuleImplementationsLoader());
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature(SCHEMA_AUGMENT_PSVI_FEATURE, false);
        if (grammarPool != null) {
            factory.setAttribute("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
        }
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(this.isValidationEnabled(validationMode));
        if (validationMode == 3) {
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (IllegalArgumentException var6) {
                ParserConfigurationException pcex = new ParserConfigurationException("Unable to validate using XSD: Your JAXP provider [" + factory + "] does not support XML Schema. Are you running on Java 1.4 with Apache Crimson? Upgrade to Apache Xerces (or Java 1.5) for full XSD support.");
                pcex.initCause(var6);
                throw pcex;
            }
        }
        return factory;
    }

    private boolean isValidationEnabled(int validationMode) {
        return validationMode != 0;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory, EntityResolver entityResolver, ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        if (entityResolver != null) {
            docBuilder.setEntityResolver(entityResolver);
        }
        if (errorHandler != null) {
            docBuilder.setErrorHandler(errorHandler);
        }
        return docBuilder;
    }

    private final class DefaultXmlMetadataFactory
    implements XmlMetadataAnnotationsFactory {
        private DefaultXmlMetadataFactory() {
        }

        @Override
        public XmlMetadataAnnotations create(Locator locator) {
            return new DefaultXmlMetadataAnnotations();
        }
    }

    public static final class XmlMetadataAnnotator
    extends DefaultHandler {
        private static final int OPENING_TRACKING_POINT_OFFSET = "<".length();
        private static final int CLOSING_TRACKING_POINT_OFFSET = "</".length();
        private Locator locator;
        private DomWalkerElement walker;
        private final XmlMetadataAnnotationsFactory metadataFactory;
        private final Deque<XmlMetadataAnnotations> annotationsStack = new ArrayDeque<XmlMetadataAnnotations>();
        private SourcePosition trackingPoint = new SourcePosition();
        private boolean writingBody = false;
        private boolean startOfMarkupConsumed = false;

        private XmlMetadataAnnotator(Document doc, XmlMetadataAnnotationsFactory metadataFactory) {
            this.walker = new DomWalkerElement(doc.getDocumentElement());
            this.metadataFactory = metadataFactory;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.writingBody = false;
            this.walker = this.walker.walkIn();
            XmlMetadataAnnotations metadataBuilder = this.metadataFactory.create(this.locator);
            int trackingPointOffset = this.getTrackingPointOffsetForStartElement();
            metadataBuilder.getOpeningTagBoundaries().setStartLineNumber(this.trackingPoint.getLine());
            metadataBuilder.getOpeningTagBoundaries().setStartColumnNumber(this.trackingPoint.getColumn() - trackingPointOffset);
            metadataBuilder.getOpeningTagBoundaries().setEndLineNumber(this.locator.getLineNumber());
            metadataBuilder.getOpeningTagBoundaries().setEndColumnNumber(this.locator.getColumnNumber());
            LinkedHashMap<String, String> attsMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                attsMap.put(atts.getQName(i), atts.getValue(i));
            }
            metadataBuilder.appendElementStart(qName, attsMap);
            this.annotationsStack.push(metadataBuilder);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.startOfMarkupConsumed = start != 0;
            this.updateTrackingPoint();
            String body = new String(ch, start, length).trim();
            if (!StringUtils.isEmpty((CharSequence)body)) {
                if (!this.writingBody) {
                    this.annotationsStack.peek().appendElementBody("<![CDATA[" + System.lineSeparator());
                }
                this.annotationsStack.peek().appendElementBody(body);
                this.writingBody = true;
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.updateTrackingPoint();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.writingBody) {
                this.annotationsStack.peek().appendElementBody(System.lineSeparator() + "]]>");
            }
            this.writingBody = false;
            XmlMetadataAnnotations metadataAnnotations = this.annotationsStack.pop();
            int trackingPointOffset = this.getTrackingPointOffsetForEndElement(metadataAnnotations);
            metadataAnnotations.getClosingTagBoundaries().setStartLineNumber(this.trackingPoint.getLine());
            metadataAnnotations.getClosingTagBoundaries().setStartColumnNumber(this.trackingPoint.getColumn() - trackingPointOffset);
            metadataAnnotations.getClosingTagBoundaries().setEndLineNumber(this.locator.getLineNumber());
            metadataAnnotations.getClosingTagBoundaries().setEndColumnNumber(this.locator.getColumnNumber());
            metadataAnnotations.appendElementEnd(qName);
            if (!this.annotationsStack.isEmpty()) {
                XmlMetadataAnnotations xmlMetadataAnnotations = this.annotationsStack.peek();
                xmlMetadataAnnotations.appendElementBody(System.lineSeparator() + metadataAnnotations.getElementString() + System.lineSeparator());
            }
            this.walker.getParentNode().setUserData("metadataAnnotations", metadataAnnotations, COPY_METADATA_ANNOTATIONS_DATA_HANDLER);
            this.walker = this.walker.walkOut();
            this.updateTrackingPoint();
        }

        private void updateTrackingPoint() {
            SourcePosition item = new SourcePosition(this.locator.getLineNumber(), this.locator.getColumnNumber());
            if (this.trackingPoint.compareTo(item) < 0) {
                this.trackingPoint = item;
            }
        }

        private int getTrackingPointOffsetForStartElement() {
            return this.startOfMarkupConsumed ? OPENING_TRACKING_POINT_OFFSET : 0;
        }

        private int getTrackingPointOffsetForEndElement(XmlMetadataAnnotations metadataAnnotations) {
            if (!this.startOfMarkupConsumed) {
                return 0;
            }
            XmlMetadataAnnotations.TagBoundaries openingTagBoundaries = metadataAnnotations.getOpeningTagBoundaries();
            if (openingTagBoundaries.getStartLineNumber() == this.trackingPoint.getLine() && openingTagBoundaries.getStartColumnNumber() == this.trackingPoint.getColumn() - OPENING_TRACKING_POINT_OFFSET) {
                return OPENING_TRACKING_POINT_OFFSET;
            }
            return CLOSING_TRACKING_POINT_OFFSET;
        }
    }

    private static final class DomWalkerElement {
        private final DomWalkerElement parent;
        private final Node node;
        private int childIndex = 0;

        public DomWalkerElement(Node node) {
            this.parent = null;
            this.node = node;
        }

        private DomWalkerElement(DomWalkerElement parent, Node node) {
            this.parent = parent;
            this.node = node;
        }

        public DomWalkerElement walkIn() {
            Node nextChild = this.node.getChildNodes().item(this.childIndex++);
            while (nextChild != null && nextChild.getNodeType() != 1) {
                nextChild = this.node.getChildNodes().item(this.childIndex++);
            }
            return new DomWalkerElement(this, nextChild);
        }

        public DomWalkerElement walkOut() {
            Node nextSibling;
            for (nextSibling = this.parent.node.getNextSibling(); nextSibling != null && nextSibling.getNodeType() != 1; nextSibling = nextSibling.getNextSibling()) {
            }
            return new DomWalkerElement(this.parent.parent, nextSibling);
        }

        public Node getParentNode() {
            return this.parent.node;
        }
    }
}

