/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.param.display.Placement;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.file.FilePath;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Collection<Field> getParameterFields(Class<?> declaringType) {
        return TypeUtils.getAllFields(declaringType).stream().filter(field -> TypeUtils.isParameter(field) || TypeUtils.isParameterGroup(field)).collect(Collectors.toList());
    }

    public static Collection<Field> getAllFields(Class<?> declaringType) {
        return TypeUtils.getAllSuperClasses(declaringType).stream().flatMap(type -> Stream.of(type.getDeclaredFields())).collect(Collectors.toList());
    }

    public static Collection<Class<?>> getAllSuperClasses(Class<?> type) {
        LinkedList result = new LinkedList();
        if (type != null && !type.equals(Object.class)) {
            result.add(type);
            result.addAll(TypeUtils.getAllSuperClasses(type.getSuperclass()));
        }
        return result;
    }

    @Deprecated
    public static String getAlias(Field field) {
        return JavaParserUtils.getAlias(field, field::getName);
    }

    public static boolean isParameter(Field field) {
        return field.isAnnotationPresent(org.mule.runtime.extension.api.annotation.param.Parameter.class) || field.isAnnotationPresent(Parameter.class);
    }

    public static boolean isParameterGroup(Field field) {
        return field.isAnnotationPresent(org.mule.runtime.extension.api.annotation.param.ParameterGroup.class) || field.isAnnotationPresent(ParameterGroup.class);
    }

    public static boolean isOptional(Field field) {
        return field.isAnnotationPresent(org.mule.runtime.extension.api.annotation.param.Optional.class) || field.isAnnotationPresent(Optional.class);
    }

    public static java.util.Optional<String> getDisplayName(Field field) {
        String displayNameValue = TypeUtils.getAnnotationValueFromField(field, org.mule.runtime.extension.api.annotation.param.display.DisplayName.class, DisplayName.class, org.mule.runtime.extension.api.annotation.param.display.DisplayName::value, DisplayName::value);
        return java.util.Optional.ofNullable(displayNameValue);
    }

    public static java.util.Optional<String> getSummaryValue(Field field) {
        String summaryValue = TypeUtils.getAnnotationValueFromField(field, org.mule.runtime.extension.api.annotation.param.display.Summary.class, Summary.class, org.mule.runtime.extension.api.annotation.param.display.Summary::value, Summary::value);
        return java.util.Optional.ofNullable(summaryValue);
    }

    public static java.util.Optional<String> getExampleValue(Field field) {
        String exampleValue = TypeUtils.getAnnotationValueFromField(field, Example.class, org.mule.sdk.api.annotation.param.display.Example.class, Example::value, org.mule.sdk.api.annotation.param.display.Example::value);
        return java.util.Optional.ofNullable(exampleValue);
    }

    public static java.util.Optional<PathModel> getPathModel(Field field) {
        Function<Path, PathModel> getPathModelFromLegacyAnnotation = path -> new PathModel(path.type(), path.acceptsUrls(), path.location(), path.acceptedFileExtensions());
        Function<FilePath, PathModel> getPathModelFromSdkAnnotation = filePath -> new PathModel(filePath.type(), filePath.acceptsUrls(), filePath.location(), filePath.acceptedFileExtensions());
        PathModel pathModel = TypeUtils.getAnnotationValueFromField(field, Path.class, FilePath.class, getPathModelFromLegacyAnnotation, getPathModelFromSdkAnnotation);
        return java.util.Optional.ofNullable(pathModel);
    }

    public static java.util.Optional<ClassValueModel> getClassValueModel(Field field) {
        Function<ClassValue, ClassValueModel> getClassValueFromLegacyAnnotation = classValue -> new ClassValueModel(Stream.of(classValue.extendsOrImplements()).filter(p -> !StringUtils.isBlank((CharSequence)p)).collect(Collectors.toList()));
        Function<org.mule.sdk.api.annotation.param.display.ClassValue, ClassValueModel> getClassValueFromSdkAnnotation = classValue -> new ClassValueModel(Stream.of(classValue.extendsOrImplements()).filter(p -> !StringUtils.isBlank((CharSequence)p)).collect(Collectors.toList()));
        ClassValueModel classValueModel = TypeUtils.getAnnotationValueFromField(field, ClassValue.class, org.mule.sdk.api.annotation.param.display.ClassValue.class, getClassValueFromLegacyAnnotation, getClassValueFromSdkAnnotation);
        return java.util.Optional.ofNullable(classValueModel);
    }

    public static java.util.Optional<Pair<Integer, String>> getPlacementValue(Field field) {
        Pair value = TypeUtils.getAnnotationValueFromField(field, org.mule.runtime.extension.api.annotation.param.display.Placement.class, Placement.class, placement -> new Pair<Integer, String>(placement.order(), placement.tab()), placement -> new Pair<Integer, String>(placement.order(), placement.tab()));
        return java.util.Optional.ofNullable(value);
    }

    public static boolean isTextField(Field field) {
        return TypeUtils.isAnnotationPresentOnField(field, Text.class, org.mule.sdk.api.annotation.param.display.Text.class);
    }

    public static boolean isPasswordField(Field field) {
        return TypeUtils.isAnnotationPresentOnField(field, Password.class);
    }

    public static boolean isQueryField(Field field) {
        return TypeUtils.isAnnotationPresentOnField(field, Query.class);
    }

    public static <R extends Annotation> boolean isAnnotationPresentOnField(Field field, Class<R> annotationClass) {
        return field.getAnnotation(annotationClass) != null;
    }

    public static <R extends Annotation, S extends Annotation> boolean isAnnotationPresentOnField(Field field, Class<R> legacyAnnotationClass, Class<S> sdkAnnotationClass) {
        R legacyAnnotation = field.getAnnotation(legacyAnnotationClass);
        S sdkAnnotation = field.getAnnotation(sdkAnnotationClass);
        if (legacyAnnotation != null && sdkAnnotation != null) {
            throw new IllegalParameterModelDefinitionException(String.format("Annotations %s and %s are both present at the same time on field %s", legacyAnnotationClass.getName(), sdkAnnotationClass.getName(), field.getName()));
        }
        return legacyAnnotation != null || sdkAnnotation != null;
    }

    private static <R extends Annotation, S extends Annotation, T> T getAnnotationValueFromField(Field field, Class<R> legacyAnnotationClass, Class<S> sdkAnnotationClass, Function<R, T> legacyAnnotationMapping, Function<S, T> sdkAnnotationMapping) {
        R legacyAnnotation = field.getAnnotation(legacyAnnotationClass);
        S sdkAnnotation = field.getAnnotation(sdkAnnotationClass);
        if (legacyAnnotation != null && sdkAnnotation != null) {
            throw new IllegalParameterModelDefinitionException(String.format("Annotations %s and %s are both present at the same time on field %s", legacyAnnotationClass.getName(), sdkAnnotationClass.getName(), field.getName()));
        }
        Object value = legacyAnnotation != null ? legacyAnnotationMapping.apply(legacyAnnotation) : (sdkAnnotation != null ? sdkAnnotationMapping.apply(sdkAnnotation) : null);
        return value;
    }
}

