/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.metadata;

import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.metadata.AbstractMetadataResultJsonSerializer;
import org.mule.runtime.extension.internal.persistence.metadata.TypeMetadata;

public class EntityMetadataResultJsonSerializer
extends AbstractMetadataResultJsonSerializer<TypeMetadataDescriptor> {
    public EntityMetadataResultJsonSerializer(boolean prettyPrint) {
        super(prettyPrint);
    }

    @Override
    public String serialize(MetadataResult<TypeMetadataDescriptor> result) {
        return this.gson.toJson((Object)new EntityMetadataResult(result));
    }

    @Override
    public MetadataResult<TypeMetadataDescriptor> deserialize(String result) {
        EntityMetadataResult entityMetadataResult = (EntityMetadataResult)this.gson.fromJson(result, new TypeToken<EntityMetadataResult>(){}.getType());
        return entityMetadataResult.toEntityMetadataResult();
    }

    private class EntityMetadataResult {
        private final TypeMetadata entity;
        private final List<MetadataFailure> failures;

        EntityMetadataResult(MetadataResult<TypeMetadataDescriptor> result) {
            this.entity = result.get() != null ? new TypeMetadata(result.get().getType(), false) : null;
            this.failures = result.getFailures();
        }

        TypeMetadata getEntity() {
            return this.entity;
        }

        MetadataResult<TypeMetadataDescriptor> toEntityMetadataResult() {
            if (this.entity == null) {
                return MetadataResult.failure(this.failures);
            }
            TypeMetadataDescriptor result = TypeMetadataDescriptor.builder().withType(this.entity.getType()).build();
            return this.failures.isEmpty() ? MetadataResult.success(result) : MetadataResult.failure(result, this.failures);
        }
    }
}

