/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.metadata;

import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.metadata.AbstractMetadataResultJsonSerializer;

public class MetadataKeysResultJsonSerializer
extends AbstractMetadataResultJsonSerializer {
    public MetadataKeysResultJsonSerializer() {
        super(false);
    }

    public MetadataKeysResultJsonSerializer(boolean prettyPrint) {
        super(prettyPrint);
    }

    public String serialize(MetadataResult metadataResult) {
        return this.gson.toJson((Object)new MetadataKeysResult(metadataResult));
    }

    public MetadataResult<MetadataKeysContainer> deserialize(String metadataResult) {
        MetadataKeysResult result = (MetadataKeysResult)this.gson.fromJson(metadataResult, new TypeToken<MetadataKeysResult>(){}.getType());
        return result.toKeysMetadataResult();
    }

    private class MetadataKeysResult {
        private final Map<String, Set<MetadataKey>> keys;
        private final List<MetadataFailure> failures;

        MetadataKeysResult(MetadataResult<MetadataKeysContainer> result) {
            this.failures = result.getFailures();
            this.keys = result.get() != null ? result.get().getKeysByCategory() : Collections.emptyMap();
        }

        MetadataResult<MetadataKeysContainer> toKeysMetadataResult() {
            MetadataKeysContainerBuilder builder = MetadataKeysContainerBuilder.getInstance();
            return this.failures.isEmpty() ? MetadataResult.success(builder.addAll(this.keys).build()) : MetadataResult.failure(builder.build(), this.failures);
        }
    }
}

