/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.factories;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.beanutils.BeanUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.connection.ConnectionUtils;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.module.extension.api.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.config.dsl.connection.ConnectionProviderObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlSdkConnectionProviderWrapper<C>
implements ConnectionProvider<C>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlSdkConnectionProviderWrapper.class);
    private final ComponentAst innerConnectionProviderComponent;
    private final Function<ComponentParameterAst, Optional<String>> propertyUsage;
    private ConnectionProvider<C> delegate;
    @Inject
    private MuleContext muleContext;
    @Inject
    private ExpressionManager expressionManager;

    public XmlSdkConnectionProviderWrapper(ComponentAst innerConnectionProviderComponent, Function<ComponentParameterAst, Optional<String>> propertyUsage) {
        this.innerConnectionProviderComponent = innerConnectionProviderComponent;
        this.propertyUsage = propertyUsage;
    }

    private ConnectionProvider<C> buildAndPopulateDelegate() throws Exception {
        ConnectionProviderObjectFactory connectionProviderObjectFactory = new ConnectionProviderObjectFactory(this.innerConnectionProviderComponent.getModel(ConnectionProviderModel.class).get(), this.innerConnectionProviderComponent.getExtensionModel(), null, null, null, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(connectionProviderObjectFactory, true, this.muleContext);
        connectionProviderObjectFactory.setParameters(this.resolveParameters(this.innerConnectionProviderComponent));
        ConnectionProviderResolver connectionProviderResolver = connectionProviderObjectFactory.doGetObject();
        LifecycleUtils.initialiseIfNeeded(connectionProviderResolver, true, this.muleContext);
        ConnectionProviderObjectBuilder objectBuilder = connectionProviderResolver.getObjectBuilder().get();
        ResolverSetResult resolvedResolverSet = this.resolveResolverSet(connectionProviderResolver.getResolverSet().get());
        Pair built = objectBuilder.build(resolvedResolverSet);
        return built.getFirst();
    }

    private Map<String, Object> resolveParameters(ComponentAst connectionProviderComponent) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (ComponentParameterAst p : connectionProviderComponent.getParameters()) {
            if (p.getRawValue() == null) {
                if (!p.getValue().isRight() || !(p.getValue().getRight() instanceof ComponentAst)) continue;
                ComponentAst complexParamValue = (ComponentAst)p.getValue().getRight();
                MetadataType type = complexParamValue.getModel(MetadataTypeAdapter.class).get().getType();
                parameters.put(p.getModel().getName(), new StaticValueResolver<Object>(this.buildComplexParam(type, this.resolveParameters(complexParamValue))));
                continue;
            }
            Optional<String> propertyNameOpt = this.propertyUsage.apply(p);
            if (!propertyNameOpt.isPresent()) continue;
            String propertyName = propertyNameOpt.get();
            parameters.put(p.getModel().getName(), this.paramValueResolver(BeanUtils.getProperty((Object)this, (String)propertyName), p.getModel().getType(), p.getModel().getDefaultValue()));
        }
        return parameters;
    }

    private Object buildComplexParam(MetadataType type, Map<String, Object> parameters) throws Exception {
        TopLevelParameterObjectFactory topLevelParameterObjectFactory = new TopLevelParameterObjectFactory((ObjectType)type, this.muleContext.getExecutionClassLoader(), this.muleContext);
        LifecycleUtils.initialiseIfNeeded(topLevelParameterObjectFactory, true, this.muleContext);
        topLevelParameterObjectFactory.setParameters(parameters);
        return topLevelParameterObjectFactory.doGetObject();
    }

    private ValueResolver paramValueResolver(Object paramValue, MetadataType type, Object defaultValue) {
        StaticValueResolver<Object> staticDelegate = new StaticValueResolver<Object>(paramValue != null ? paramValue : defaultValue);
        return new TypeSafeValueResolverWrapper(staticDelegate, JavaTypeUtils.getType(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolverSetResult resolveResolverSet(ResolverSet resolverSet) throws MuleException {
        ResolverSetResult result;
        CoreEvent initializerEvent = NullEventFactory.getNullEvent();
        try (ValueResolvingContext ctx = ValueResolvingContext.builder(initializerEvent, this.expressionManager).build();){
            result = resolverSet.resolve(ctx);
        }
        finally {
            ((BaseEventContext)initializerEvent.getContext()).success();
        }
        return result;
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.delegate = this.buildAndPopulateDelegate();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        this.delegate = null;
    }

    @Override
    public C connect() throws ConnectionException {
        return ConnectionUtils.connect(this.delegate);
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        return this.delegate.validate(connection);
    }

    @Override
    public void disconnect(C connection) {
        this.delegate.disconnect(connection);
    }
}

