/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.util.Collection;
import java.util.LinkedList;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.DefaultMethodRequestMatcher;
import org.mule.runtime.http.api.server.MethodRequestMatcher;

public class MethodRequestMatcherBuilder {
    private final Collection<String> methods = new LinkedList<String>();

    MethodRequestMatcherBuilder() {
    }

    MethodRequestMatcherBuilder(Collection<String> methods) {
        Preconditions.checkArgument(methods != null, "methods attribute should not be null");
        methods.forEach(method -> this.methods.add(method.toUpperCase()));
    }

    public MethodRequestMatcherBuilder add(String method) {
        Preconditions.checkArgument(method != null, "method attribute should not be null");
        this.methods.add(method.toUpperCase());
        return this;
    }

    public MethodRequestMatcherBuilder add(HttpConstants.Method method) {
        Preconditions.checkArgument(method != null, "method attribute should not be null");
        return this.add(method.name());
    }

    public MethodRequestMatcher build() {
        Preconditions.checkArgument(this.methods.size() > 0, "methods attribute should not be empty");
        return new DefaultMethodRequestMatcher(this.methods);
    }
}

