/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.cache.ComponentBasedIdHelper;
import org.mule.runtime.metadata.internal.types.AttributesMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.InputMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.KeysMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.MetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.OutputMetadataResolutionTypeInformation;

public class ComponentAstBasedMetadataCacheIdGenerator
implements MetadataCacheIdGenerator<ComponentAst> {
    private final ComponentLocator<ComponentAst> locator;

    public ComponentAstBasedMetadataCacheIdGenerator(ComponentLocator<ComponentAst> locator) {
        this.locator = locator;
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentOutputMetadata(ComponentAst component) {
        return component.getModel(HasOutputModel.class).flatMap(hom -> this.doResolveType(component, new OutputMetadataResolutionTypeInformation(component)));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentAttributesMetadata(ComponentAst component) {
        return component.getModel(HasOutputModel.class).flatMap(hom -> this.doResolveType(component, new AttributesMetadataResolutionTypeInformation(component)));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentInputMetadata(ComponentAst component, String parameterName) {
        Preconditions.checkArgument(component.getModel(ParameterizedModel.class).isPresent(), () -> "Cannot generate an Input Cache Key for component '" + component.toString() + "' with no parameters");
        Preconditions.checkArgument(component.getModel(ParameterizedModel.class).get().getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals(parameterName)), () -> "Cannot generate an Input Cache Key for component '" + component.toString() + "' since it does not have a parameter named " + parameterName);
        return this.doResolveType(component, new InputMetadataResolutionTypeInformation(component, parameterName));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentMetadata(ComponentAst elementModel) {
        return this.doResolve(elementModel);
    }

    @Override
    public Optional<MetadataCacheId> getIdForMetadataKeys(ComponentAst elementModel) {
        return this.doResolveType(elementModel, new KeysMetadataResolutionTypeInformation(elementModel));
    }

    @Override
    public Optional<MetadataCacheId> getIdForGlobalMetadata(ComponentAst elementModel) {
        ArrayList keyParts = new ArrayList();
        return Optional.of(elementModel.getModel(ConfigurationModel.class).map(cfgModel -> {
            keyParts.add(ComponentBasedIdHelper.resolveComponentIdentifierMetadataCacheId(elementModel));
            this.resolveGlobalElement(elementModel).ifPresent(keyParts::add);
            return new MetadataCacheId(keyParts, ComponentBasedIdHelper.sourceElementName(elementModel));
        }).orElseGet(() -> {
            Optional<MetadataCacheId> configId = this.resolveConfigId(elementModel);
            if (configId.isPresent()) {
                keyParts.add(configId.get());
                this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
                return new MetadataCacheId(keyParts, ComponentBasedIdHelper.sourceElementName(elementModel));
            }
            return ComponentBasedIdHelper.resolveComponentIdentifierMetadataCacheId(elementModel);
        }));
    }

    private Optional<MetadataCacheId> resolveCategoryId(ComponentAst elementModel) {
        return elementModel.getModel(ComponentModel.class).flatMap(model -> model.getModelProperty(MetadataKeyIdModelProperty.class)).map(mp -> mp.getCategoryName().orElse(null)).map(this::createCategoryMetadataCacheId);
    }

    private Optional<MetadataCacheId> doResolveType(ComponentAst component, MetadataResolutionTypeInformation typeInformation) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        if (typeInformation.isDynamicType()) {
            this.resolveDslTagNamespace(component).ifPresent(keyParts::add);
            this.resolveConfigId(component).ifPresent(keyParts::add);
            typeInformation.getResolverCategory().ifPresent(resolverCategory -> keyParts.add(this.createCategoryMetadataCacheId((String)resolverCategory)));
            typeInformation.getResolverName().ifPresent(resolverName -> keyParts.add(this.createResolverMetadataCacheId((String)resolverName)));
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
            component.getModel(ComponentModel.class).flatMap(cmpModel -> ComponentBasedIdHelper.resolveMetadataKeyParts(component, cmpModel, typeInformation.shouldIncludeConfiguredMetadataKeys(), this::getHashedGlobal)).ifPresent(keyParts::add);
        } else {
            keyParts.add(ComponentBasedIdHelper.resolveComponentIdentifierMetadataCacheId(component));
            component.getModel(ConfigurationModel.class).flatMap(cfgModel -> this.resolveGlobalElement(component)).ifPresent(keyParts::add);
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
        }
        return Optional.of(new MetadataCacheId(keyParts, typeInformation.getComponentTypeMetadataCacheId().getSourceElementName().map(sourceElementName -> String.format("(%s):(%s)", ComponentBasedIdHelper.sourceElementName(component), sourceElementName)).orElse(String.format("(%s):(%s)", ComponentBasedIdHelper.sourceElementName(component), "Unknown Type"))));
    }

    private Optional<MetadataCacheId> resolveDslTagNamespace(ComponentAst elementModel) {
        String namespace = elementModel.getIdentifier().getNamespace();
        return Optional.of(new MetadataCacheId(namespace.toLowerCase().hashCode(), namespace));
    }

    private Optional<MetadataCacheId> doResolve(ComponentAst elementModel) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        this.resolveConfigId(elementModel).ifPresent(keyParts::add);
        this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
        keyParts.add(ComponentBasedIdHelper.resolveComponentIdentifierMetadataCacheId(elementModel));
        elementModel.getModel(ComponentModel.class).map(model -> ComponentBasedIdHelper.resolveMetadataKeyParts(elementModel, model, true, this::getHashedGlobal)).orElseGet(() -> this.resolveGlobalElement(elementModel)).ifPresent(keyParts::add);
        return Optional.of(new MetadataCacheId(keyParts, ComponentBasedIdHelper.sourceElementName(elementModel)));
    }

    private Optional<MetadataCacheId> resolveConfigId(ComponentAst elementModel) {
        return ComponentBasedIdHelper.resolveConfigName(elementModel).flatMap(this::getHashedGlobal);
    }

    private Optional<MetadataCacheId> resolveGlobalElement(ComponentAst elementModel) {
        List<String> parameterNamesRequiredForMetadata = ComponentBasedIdHelper.parameterNamesRequiredForMetadataCacheId(elementModel);
        List<MetadataCacheId> parts = Stream.concat(elementModel.directChildrenStream().map(this::doResolve).filter(Optional::isPresent).map(Optional::get), elementModel.getModel(ParameterizedModel.class).map(pmz -> elementModel.getParameters().stream().filter(p -> p.getValue().getValue().isPresent()).filter(p -> parameterNamesRequiredForMetadata.contains(p.getModel().getName())).map(p -> ComponentBasedIdHelper.resolveKeyFromSimpleValue(elementModel, p, this::getHashedGlobal))).orElse(Stream.empty())).collect(Collectors.toList());
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MetadataCacheId(parts, (String)ComponentBasedIdHelper.getModelNameAst(elementModel).orElse(null)));
    }

    private MetadataCacheId createCategoryMetadataCacheId(String category) {
        return new MetadataCacheId(category.hashCode(), "category: " + category);
    }

    private MetadataCacheId createResolverMetadataCacheId(String resolverName) {
        return new MetadataCacheId(resolverName.hashCode(), "resolver: " + resolverName);
    }

    private Optional<MetadataCacheId> getHashedGlobal(String name) {
        if (StringUtils.isBlank(name)) {
            return Optional.empty();
        }
        return this.locator.get(Location.builder().globalName(name).build()).flatMap(this::doResolve);
    }
}

