/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.runtime.metadata.internal.DslElementIdHelper;
import org.mule.runtime.metadata.internal.types.AttributesMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.InputMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.KeysMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.MetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.OutputMetadataResolutionTypeInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslElementBasedMetadataCacheIdGenerator
implements MetadataCacheIdGenerator<DslElementModel<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DslElementBasedMetadataCacheIdGenerator.class);
    private final ComponentLocator<DslElementModel<?>> locator;

    public DslElementBasedMetadataCacheIdGenerator(ComponentLocator<DslElementModel<?>> locator) {
        this.locator = locator;
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentOutputMetadata(DslElementModel<?> component) {
        if (component.getModel() == null || !(component.getModel() instanceof HasOutputModel)) {
            return Optional.empty();
        }
        return this.doResolveType(component, new OutputMetadataResolutionTypeInformation(component));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentAttributesMetadata(DslElementModel<?> component) {
        if (component.getModel() == null || !(component.getModel() instanceof HasOutputModel)) {
            return Optional.empty();
        }
        return this.doResolveType(component, new AttributesMetadataResolutionTypeInformation(component));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentInputMetadata(DslElementModel<?> component, String parameterName) {
        Preconditions.checkArgument(component.getModel() != null, "Cannot generate an Input Cache Key for a 'null' component");
        Preconditions.checkArgument(component.getModel() instanceof ParameterizedModel, "Cannot generate an Input Cache Key for a component with no parameters");
        Preconditions.checkArgument(((ParameterizedModel)component.getModel()).getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals(parameterName)), "Cannot generate an Input Cache Key for the component since it does not have a parameter named " + parameterName);
        return this.doResolveType(component, new InputMetadataResolutionTypeInformation(component, parameterName));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentMetadata(DslElementModel<?> elementModel) {
        return this.doResolve(elementModel);
    }

    @Override
    public Optional<MetadataCacheId> getIdForMetadataKeys(DslElementModel<?> elementModel) {
        return this.doResolveType(elementModel, new KeysMetadataResolutionTypeInformation(elementModel));
    }

    @Override
    public Optional<MetadataCacheId> getIdForGlobalMetadata(DslElementModel<?> elementModel) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        if (elementModel.getModel() instanceof ConfigurationModel) {
            this.resolveDslTagId(elementModel).ifPresent(keyParts::add);
            this.resolveGlobalElement(elementModel).ifPresent(keyParts::add);
            return Optional.of(new MetadataCacheId(keyParts, DslElementIdHelper.getSourceElementName(elementModel)));
        }
        Optional<MetadataCacheId> configId = this.resolveConfigId(elementModel);
        if (configId.isPresent()) {
            keyParts.add(configId.get());
            this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
            return Optional.of(new MetadataCacheId(keyParts, DslElementIdHelper.getSourceElementName(elementModel)));
        }
        return this.resolveDslTagId(elementModel);
    }

    private Optional<MetadataCacheId> resolveCategoryId(DslElementModel<?> elementModel) {
        if (!(elementModel.getModel() instanceof ComponentModel)) {
            return Optional.empty();
        }
        return ((ComponentModel)elementModel.getModel()).getModelProperty(MetadataKeyIdModelProperty.class).map(mp -> mp.getCategoryName().orElse(null)).map(this::createCategoryMetadataCacheId);
    }

    private Optional<MetadataCacheId> doResolveType(DslElementModel<?> component, MetadataResolutionTypeInformation typeInformation) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        if (typeInformation.isDynamicType()) {
            this.resolveDslTagNamespace(component).ifPresent(keyParts::add);
            this.resolveConfigId(component).ifPresent(keyParts::add);
            typeInformation.getResolverCategory().ifPresent(resolverCategory -> keyParts.add(this.createCategoryMetadataCacheId((String)resolverCategory)));
            typeInformation.getResolverName().ifPresent(resolverName -> keyParts.add(this.createResolverMetadataCacheId((String)resolverName)));
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
            Object model = component.getModel();
            if (model instanceof ComponentModel) {
                this.resolveMetadataKeyParts(component, (ComponentModel)model, typeInformation.shouldIncludeConfiguredMetadataKeys()).ifPresent(keyParts::add);
            }
        } else {
            this.resolveDslTagId(component).ifPresent(keyParts::add);
            if (component.getModel() instanceof ConfigurationModel) {
                this.resolveGlobalElement(component).ifPresent(keyParts::add);
            }
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
        }
        return Optional.of(new MetadataCacheId(keyParts, typeInformation.getComponentTypeMetadataCacheId().getSourceElementName().map(sourceElementName -> String.format("(%s):(%s)", DslElementIdHelper.getSourceElementName(component), sourceElementName)).orElse(String.format("(%s):(%s)", DslElementIdHelper.getSourceElementName(component), "Unknown Type"))));
    }

    private Optional<MetadataCacheId> doResolve(DslElementModel<?> elementModel) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        this.resolveConfigId(elementModel).ifPresent(keyParts::add);
        this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
        this.resolveDslTagId(elementModel).ifPresent(keyParts::add);
        Object model = elementModel.getModel();
        if (model instanceof ComponentModel) {
            this.resolveMetadataKeyParts(elementModel, (ComponentModel)model, true).ifPresent(keyParts::add);
        } else {
            this.resolveGlobalElement(elementModel).ifPresent(keyParts::add);
        }
        return Optional.of(new MetadataCacheId(keyParts, DslElementIdHelper.getSourceElementName(elementModel)));
    }

    private Optional<MetadataCacheId> resolveDslTagId(DslElementModel<?> elementModel) {
        return elementModel.getIdentifier().map(id -> new MetadataCacheId(id.hashCode(), id.toString()));
    }

    private Optional<MetadataCacheId> resolveDslTagNamespace(DslElementModel<?> elementModel) {
        return elementModel.getIdentifier().map(id -> new MetadataCacheId(id.getNamespace().toLowerCase().hashCode(), id.getNamespace()));
    }

    private Optional<MetadataCacheId> resolveConfigId(DslElementModel<?> elementModel) {
        return DslElementIdHelper.resolveConfigName(elementModel).flatMap(this::getHashedGlobal);
    }

    private Optional<MetadataCacheId> resolveGlobalElement(DslElementModel<?> elementModel) {
        ArrayList<MetadataCacheId> parts = new ArrayList<MetadataCacheId>();
        List<String> parameterNamesRequiredForMetadata = this.parameterNamesRequiredForMetadataCacheId(elementModel.getModel());
        elementModel.getContainedElements().stream().filter(containedElement -> containedElement.getModel() != null).filter(containedElement -> this.isRequiredForMetadata(parameterNamesRequiredForMetadata, containedElement.getModel())).forEach(containedElement -> {
            if (containedElement.getValue().isPresent()) {
                this.resolveKeyFromSimpleValue((DslElementModel<?>)containedElement).ifPresent(parts::add);
            } else {
                this.getIdForComponentMetadata((DslElementModel<?>)containedElement).ifPresent(parts::add);
            }
        });
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MetadataCacheId(parts, (String)DslElementIdHelper.getModelName(elementModel.getModel()).orElse(null)));
    }

    private boolean isRequiredForMetadata(List<String> parameterNamesRequiredForMetadataCacheId, Object model) {
        if (model instanceof ParameterModel) {
            return parameterNamesRequiredForMetadataCacheId.contains(((ParameterModel)model).getName());
        }
        return true;
    }

    private List<String> parameterNamesRequiredForMetadataCacheId(Object model) {
        if (model instanceof EnrichableModel) {
            return ((EnrichableModel)model).getModelProperty(RequiredForMetadataModelProperty.class).map(RequiredForMetadataModelProperty::getRequiredParameters).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private Optional<MetadataCacheId> resolveMetadataKeyParts(DslElementModel<?> elementModel, ComponentModel componentModel, boolean resolveAllKeys) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        boolean isPartialFetching = componentModel.getModelProperty(TypeResolversInformationModelProperty.class).map(mp -> mp.isPartialTypeKeyResolver()).orElse(false);
        if (isPartialFetching || resolveAllKeys) {
            componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted(Comparator.comparingInt(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).get().getOrder())).map(metadataKeyPart -> elementModel.findElement(metadataKeyPart.getName())).filter(Optional::isPresent).map(Optional::get).filter(partElement -> partElement.getValue().isPresent()).forEach(partElement -> this.resolveKeyFromSimpleValue((DslElementModel<?>)partElement).ifPresent(keyParts::add));
        }
        return keyParts.isEmpty() ? Optional.empty() : Optional.of(new MetadataCacheId(keyParts, "metadataKeyValues"));
    }

    private Optional<MetadataCacheId> resolveKeyFromSimpleValue(DslElementModel<?> element) {
        return DslElementIdHelper.resolveSimpleValue(element, this.locator).flatMap(either -> either.reduce(this::getIdForComponentMetadata, r -> Optional.of(new MetadataCacheId(Objects.hashCode(r), DslElementIdHelper.sourceElementNameFromSimpleValue(element)))));
    }

    private MetadataCacheId createCategoryMetadataCacheId(String category) {
        return new MetadataCacheId(category.hashCode(), "category: " + category);
    }

    private MetadataCacheId createResolverMetadataCacheId(String resolverName) {
        return new MetadataCacheId(resolverName.hashCode(), "resolver: " + resolverName);
    }

    private Optional<MetadataCacheId> getHashedGlobal(String name) {
        return DslElementIdHelper.getGlobalElement(name, this.locator).flatMap(this::getIdForComponentMetadata);
    }
}

