/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.meter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.api.meter.builder.MeterBuilder;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.impl.meter.builder.MeterBuilderWithRepository;
import org.mule.runtime.metrics.impl.meter.repository.MeterRepository;

public abstract class BaseMeterBuilder
implements MeterBuilderWithRepository {
    private final String meterName;
    private String description;
    private MeterRepository meterRepository;
    private MeterExporter meterExporter;
    private final Map<String, String> meterAttributes = new HashMap<String, String>();

    public BaseMeterBuilder(String meterName) {
        this.meterName = meterName;
    }

    @Override
    public MeterBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public MeterBuilder withMeterAttribute(String key, String value) {
        this.meterAttributes.put(key, value);
        return this;
    }

    @Override
    public Meter build() {
        Objects.requireNonNull(this.meterExporter);
        return Optional.ofNullable(this.meterRepository).map(repository -> repository.getOrCreate(this.meterName, name -> this.doBuild((String)name, this.description, this.meterExporter, this.meterAttributes))).orElseGet(() -> this.doBuild(this.meterName, this.description, this.meterExporter, this.meterAttributes));
    }

    protected abstract Meter doBuild(String var1, String var2, MeterExporter var3, Map<String, String> var4);

    @Override
    public MeterBuilderWithRepository withMeterRepository(MeterRepository meterRepository) {
        this.meterRepository = meterRepository;
        return this;
    }

    @Override
    public MeterBuilderWithRepository withMeterExporter(MeterExporter meterExporter) {
        this.meterExporter = meterExporter;
        return this;
    }
}

