/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.ast;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.module.artifact.activation.api.ast.AstXmlParserSupplier;
import org.mule.runtime.module.artifact.activation.internal.ast.MuleSdkExtensionModelLoadingMediator;
import org.w3c.dom.Document;

public class ArtifactAstUtils {
    private static final boolean IS_MULE_SDK_ENABLED = Boolean.getBoolean("mule.experimental.enableMuleSdk");

    public static ArtifactAst parseArtifact(String artifactName, Either<ConfigResource[], Map<String, Document>> configs, AstXmlParserSupplier parserSupplier, Set<ExtensionModel> extensions, boolean disableValidations, ClassLoader artifactClassLoader, MuleSdkExtensionModelLoadingMediator extensionModelMediator) throws ConfigurationException {
        if (!IS_MULE_SDK_ENABLED) {
            return ArtifactAstUtils.doParseArtifactIntoAst(artifactName, configs, parserSupplier, extensions, disableValidations, artifactClassLoader);
        }
        ArtifactAst partialAst = ArtifactAstUtils.doParseArtifactIntoAst(artifactName, configs, parserSupplier, extensions, true, artifactClassLoader);
        Optional<ExtensionModel> extensionModel = extensionModelMediator.loadExtensionModel(partialAst, artifactClassLoader.getParent(), extensions);
        if (extensionModel.isPresent()) {
            HashSet<ExtensionModel> enrichedExtensionModels = new HashSet<ExtensionModel>(extensions);
            enrichedExtensionModels.add(extensionModel.get());
            return ArtifactAstUtils.doParseArtifactIntoAst(artifactName, configs, parserSupplier, enrichedExtensionModels, disableValidations, artifactClassLoader);
        }
        return disableValidations || configs.isRight() ? partialAst : ArtifactAstUtils.doParseArtifactIntoAst(artifactName, configs, parserSupplier, extensions, false, artifactClassLoader);
    }

    private static ArtifactAst doParseArtifactIntoAst(String artifactName, Either<ConfigResource[], Map<String, Document>> configs, AstXmlParserSupplier parserSupplier, Set<ExtensionModel> extensions, boolean disableValidations, ClassLoader artifactClassLoader) throws ConfigurationException {
        if (configs.isLeft()) {
            return parserSupplier.getParser(extensions, disableValidations).parse(artifactName, configs.getLeft());
        }
        return configs.mapRight(appXmlConfigDocuments -> {
            AstXmlParser parser = parserSupplier.getParser(extensions, true);
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            ArtifactAstUtils.setContextClassLoader(Thread.currentThread(), currentClassLoader, artifactClassLoader);
            try {
                ArtifactAst artifactAst = parser.parseDocument(artifactName, appXmlConfigDocuments.entrySet().stream().map(e -> new Pair<String, Document>((String)e.getKey(), (Document)e.getValue())).collect(Collectors.toList()));
                return artifactAst;
            }
            finally {
                ArtifactAstUtils.setContextClassLoader(Thread.currentThread(), artifactClassLoader, currentClassLoader);
            }
        }).getRight();
    }

    public static ConfigResource[] loadConfigResources(String[] configs, ClassLoader artifactClassLoader) throws ConfigurationException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ArtifactAstUtils.setContextClassLoader(Thread.currentThread(), currentClassLoader, artifactClassLoader);
        try {
            ConfigResource[] artifactConfigResources = new ConfigResource[configs.length];
            for (int i = 0; i < configs.length; ++i) {
                artifactConfigResources[i] = new ConfigResource(configs[i]);
            }
            ConfigResource[] configResourceArray = artifactConfigResources;
            return configResourceArray;
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        finally {
            ArtifactAstUtils.setContextClassLoader(Thread.currentThread(), artifactClassLoader, currentClassLoader);
        }
    }

    private static void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
        if (currentClassLoader != newClassLoader) {
            thread.setContextClassLoader(newClassLoader);
        }
    }

    private ArtifactAstUtils() {
    }
}

