/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.ast;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.boot.ExtensionLoaderUtils;
import org.mule.runtime.module.artifact.activation.internal.ast.AbstractMuleSdkExtensionModelLoadingMediator;

public class MuleSdkApplicationExtensionModelLoadingMediator
extends AbstractMuleSdkExtensionModelLoadingMediator {
    private static final Set<TypedComponentIdentifier.ComponentType> REUSABLE_COMPONENT_TYPES = Collections.singleton(TypedComponentIdentifier.ComponentType.OPERATION_DEF);
    private final String artifactId;

    public MuleSdkApplicationExtensionModelLoadingMediator(ExpressionLanguageMetadataService expressionLanguageMetadataService, String artifactId, Optional<ArtifactCoordinates> artifactCoordinates, Optional<ExtensionLoadingContext> artifactExtensionLoadingContext) {
        super(artifactCoordinates, artifactExtensionLoadingContext, expressionLanguageMetadataService);
        this.artifactId = artifactId;
    }

    @Override
    protected String getVersion() throws ConfigurationException {
        return this.artifactCoordinates.map(ArtifactCoordinates::getVersion).orElseThrow(() -> new ConfigurationException(this.buildErrorMessage("No version specified", this.artifactId)));
    }

    @Override
    protected ExtensionModelLoader getLoader() throws ConfigurationException {
        return ExtensionLoaderUtils.getOptionalLoaderById("mule_app").orElseThrow(() -> new ConfigurationException(this.buildErrorMessage("Mule ExtensionModelLoader not found", this.artifactId)));
    }

    @Override
    protected boolean containsReusableComponents(ArtifactAst ast) {
        return ast.topLevelComponentsStream().anyMatch(component -> REUSABLE_COMPONENT_TYPES.contains((Object)component.getComponentType()));
    }

    @Override
    protected void addCustomLoadingRequestParameters(ExtensionModelLoadingRequest.Builder loadingRequestBuilder) {
        super.addCustomLoadingRequestParameters(loadingRequestBuilder);
        loadingRequestBuilder.addParameter("muleSDK.artifactDescriptor", this.artifactId);
    }

    private I18nMessage buildErrorMessage(String reason, String artifactId) {
        return I18nMessageFactory.createStaticMessage("ExtensionModel for application %s not generated: %s", artifactId, reason);
    }
}

