/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.activation.internal.classloader.NativeLibraryLoaderMuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSharedDomainClassLoader
extends NativeLibraryLoaderMuleDeployableArtifactClassLoader {
    private static final Logger LOGGER;
    private final NativeLibraryFinder nativeLibraryFinder;

    public MuleSharedDomainClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy, List<URL> urls) {
        this(artifactDescriptor, parent, lookupPolicy, urls, null);
    }

    public MuleSharedDomainClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy, List<URL> urls, NativeLibraryFinder nativeLibraryFinder) {
        super(MuleSharedDomainClassLoader.getDomainId(artifactDescriptor.getName()), artifactDescriptor, parent, nativeLibraryFinder, urls, lookupPolicy);
        this.nativeLibraryFinder = nativeLibraryFinder;
    }

    @Override
    public String findLibrary(String name) {
        if (this.nativeLibraryFinder == null) {
            return super.findLibrary(name);
        }
        if (this.supportNativeLibraryDependencies) {
            this.loadNativeLibraryDependencies(name);
        }
        String libraryPath = super.findLibrary(name);
        libraryPath = this.nativeLibraryFinder.findLibrary(name, libraryPath);
        return libraryPath;
    }

    @Override
    public URL findResource(String name) {
        File file;
        URL resource = super.findResource(name);
        if (resource == null && (file = new File(String.valueOf(MuleFoldersUtil.getDomainFolder(((ArtifactDescriptor)this.getArtifactDescriptor()).getName())) + File.separator + name)).exists()) {
            try {
                resource = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Failure looking for resource", (Throwable)e);
            }
        }
        return resource;
    }

    @Override
    protected String[] getLocalResourceLocations() {
        return new String[]{MuleFoldersUtil.getDomainFolder(((ArtifactDescriptor)this.getArtifactDescriptor()).getName()).getAbsolutePath()};
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)domainName), "domainName cannot be empty");
        return "domain/" + domainName;
    }

    static {
        MuleSharedDomainClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(MuleSharedDomainClassLoader.class);
    }
}

