/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader.model.utils;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.module.artifact.activation.internal.classloader.Classifier;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;

public class ArtifactUtils {
    private static final URI EMPTY_RESOURCE = URI.create("");

    public static List<BundleDependency> toApplicationModelArtifacts(List<BundleDependency> appDependencies) {
        return appDependencies.stream().map(ArtifactUtils::updateScopeIfDomain).collect(Collectors.toList());
    }

    private static BundleDependency updateScopeIfDomain(BundleDependency artifact) {
        if (artifact.getDescriptor().getClassifier().map(Classifier.MULE_DOMAIN.toString()::equals).orElse(false).booleanValue()) {
            return BundleDependency.builder(artifact).setScope(BundleScope.PROVIDED).setBundleUri(EMPTY_RESOURCE).build();
        }
        return artifact;
    }

    public static List<BundleDependency> updatePackagesResources(List<BundleDependency> artifacts) {
        return artifacts.stream().map(ArtifactUtils::updatePackagesResources).collect(Collectors.toList());
    }

    private static BundleDependency updatePackagesResources(BundleDependency artifact) {
        if (artifact.getDescriptor().getClassifier().map(Classifier.MULE_PLUGIN.toString()::equals).orElse(false).booleanValue() || artifact.getBundleUri() == null || StringUtils.isBlank((CharSequence)artifact.getBundleUri().getPath())) {
            return artifact;
        }
        JarInfo jarInfo = new FileJarExplorer(false).explore(artifact.getBundleUri());
        return BundleDependency.builder(artifact).setPackages(jarInfo.getPackages()).setResources(jarInfo.getResources()).build();
    }

    public static List<BundleDependency> findArtifactsSharedDependencies(List<BundleDependency> appDependencies, List<String> sharedLibrariesCoordinates, List<String> activeProfiles) {
        return sharedLibrariesCoordinates.stream().flatMap(shareLibrary -> ArtifactUtils.findAndExportSharedLibraries(shareLibrary, appDependencies)).collect(Collectors.toList());
    }

    private static Stream<BundleDependency> findAndExportSharedLibraries(String sharedLibraryCoordinates, List<BundleDependency> deployableDependencies) {
        return deployableDependencies.stream().filter(bundleDependency -> sharedLibraryCoordinates.equals(bundleDependency.getDescriptor().getGroupId() + ":" + bundleDependency.getDescriptor().getArtifactId())).flatMap(sharedBundleDependency -> ArtifactUtils.filterTransitiveSharedDependencies(deployableDependencies, sharedBundleDependency));
    }

    private static Stream<BundleDependency> filterTransitiveSharedDependencies(List<BundleDependency> deployableDependencies, BundleDependency sharedBundleDependency) {
        return Stream.concat(ArtifactUtils.filterSharedArtifacts(sharedBundleDependency.getDescriptor().getGroupId(), sharedBundleDependency.getDescriptor().getArtifactId(), deployableDependencies), sharedBundleDependency.getTransitiveDependenciesList().stream().flatMap(transitiveDependency -> ArtifactUtils.filterTransitiveSharedDependencies(deployableDependencies, transitiveDependency)));
    }

    private static Stream<BundleDependency> filterSharedArtifacts(String sharedLibraryGroupId, String sharedLibraryArtifactId, List<BundleDependency> deployableDependencies) {
        return deployableDependencies.stream().filter(artifact -> artifact.getDescriptor().getGroupId().equals(sharedLibraryGroupId) && artifact.getDescriptor().getArtifactId().equals(sharedLibraryArtifactId));
    }

    public static ArtifactCoordinates getDeployableArtifactCoordinates(String groupId, String artifactId, String version, String packaging) {
        return new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setBaseVersion(version).setClassifier(packaging).build();
    }
}

