/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.extension.discovery;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoaderProvider;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.boot.ExtensionLoaderUtils;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtensionModelLoaderRepository
implements ExtensionModelLoaderRepository,
Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionModelLoaderRepository.class);
    private final Map<String, ExtensionModelLoader> extensionModelLoaders = new HashMap<String, ExtensionModelLoader>();
    private Supplier<Collection<ExtensionModelLoader>> extModelLoadersLookup = () -> this.lookupLoadersFromSpi();

    private Collection<ExtensionModelLoader> lookupLoadersFromSpi() {
        Collection loaders = ExtensionLoaderUtils.lookupExtensionModelLoaders().collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The following {} were discovered: [{}]", (Object)ExtensionModelLoader.class.getSimpleName(), (Object)loaders.stream().map(l -> l.getId()).collect(Collectors.joining(", ")));
        }
        return loaders;
    }

    public void setExtensionModelLoadersLookup(Supplier<Collection<ExtensionModelLoader>> extModelLoadersLookup) {
        this.extModelLoadersLookup = extModelLoadersLookup;
    }

    @Override
    public void start() throws MuleException {
        Collection<ExtensionModelLoader> extensionModelLoaders = this.extModelLoadersLookup.get();
        this.assertLoaderLookupUniqueness(extensionModelLoaders);
        extensionModelLoaders.forEach(loader -> this.extensionModelLoaders.put(loader.getId(), (ExtensionModelLoader)loader));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ExtensionModelLoader registered identifiers: {}", (Object)this.printExtensionModelLoaderIDs());
        }
    }

    private void assertLoaderLookupUniqueness(Collection<ExtensionModelLoader> extensionModelLoaders) {
        StringBuilder sb = new StringBuilder();
        extensionModelLoaders.stream().collect(Collectors.groupingBy(ExtensionModelLoader::getId)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            String classes = ((List)entry.getValue()).stream().map(extensionModelLoader -> extensionModelLoader.getClass().getName()).collect(Collectors.joining(", "));
            sb.append(System.lineSeparator()).append("ID [").append((String)entry.getKey()).append("] is being returned by the following classes [").append(classes).append("]");
        });
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There are several loaders that return the same identifier when looking up providers for '%s'. Full error list: %s", ExtensionModelLoaderProvider.class.getName(), sb)));
        }
    }

    @Override
    public void stop() throws MuleException {
        this.extensionModelLoaders.clear();
    }

    @Override
    public Optional<ExtensionModelLoader> getExtensionModelLoader(LoaderDescriber loaderDescriber) {
        return this.extensionModelLoaders.containsKey(loaderDescriber.getId()) ? Optional.of(this.extensionModelLoaders.get(loaderDescriber.getId())) : Optional.empty();
    }

    private String printExtensionModelLoaderIDs() {
        return this.extensionModelLoaders.keySet().stream().collect(Collectors.joining(", "));
    }

    public String toString() {
        return String.format("%s[extensionModelLoaders=%s]", this.getClass().getName(), this.printExtensionModelLoaderIDs());
    }
}

