/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.runtime.module.artifact.activation.api.deployable.MuleProjectStructure;

public class DefaultMuleProjectStructure
implements MuleProjectStructure {
    private static final String DEFAULT_SOURCES_DIRECTORY = "src/main";
    private static final String DEFAULT_SOURCES_JAVA_DIRECTORY = "/java";
    private static final String DEFAULT_MULE_DIRECTORY = "/mule";
    private static final String DEFAULT_RESOURCES_DIRECTORY = "/resources";
    private static final String DEFAULT_TEST_RESOURCES_DIRECTORY = "/test/resources";
    private final Path projectFolder;
    private final Path javaDirectory;
    private final Path muleResourcesDirectory;
    private final List<Path> resourcesDirectories;

    public DefaultMuleProjectStructure(Path projectFolder, MavenPomParser parser, boolean includeTestDependencies) {
        this.projectFolder = projectFolder;
        String sourceDirectory = parser.getSourceDirectory();
        this.javaDirectory = Paths.get(projectFolder.toAbsolutePath().toString(), sourceDirectory.concat(DEFAULT_SOURCES_JAVA_DIRECTORY));
        this.muleResourcesDirectory = Paths.get(projectFolder.toAbsolutePath().toString(), parser.getSourceDirectory().concat(DEFAULT_MULE_DIRECTORY));
        ArrayList<Path> resourcesDirectories = new ArrayList<Path>();
        if (includeTestDependencies) {
            resourcesDirectories.add(Paths.get(projectFolder.toAbsolutePath().toString(), parser.getSourceDirectory().concat(DEFAULT_TEST_RESOURCES_DIRECTORY)));
        }
        if (parser.getResourceDirectories().isEmpty()) {
            resourcesDirectories.add(Paths.get(projectFolder.toAbsolutePath().toString(), parser.getSourceDirectory().concat(DEFAULT_RESOURCES_DIRECTORY)));
        } else {
            parser.getResourceDirectories().forEach(resourceDir -> resourcesDirectories.add(Paths.get(projectFolder.toAbsolutePath().toString(), resourceDir)));
        }
        this.resourcesDirectories = Collections.unmodifiableList(resourcesDirectories);
    }

    @Override
    public Path getProjectFolder() {
        return this.projectFolder;
    }

    @Override
    public Path getJavaDirectory() {
        return this.javaDirectory;
    }

    @Override
    public Path getMuleResourcesDirectory() {
        return this.muleResourcesDirectory;
    }

    @Override
    public Collection<Path> getResourcesDirectories() {
        return this.resourcesDirectories;
    }
}

