/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDependencyVersionException;

public class BundleDescriptorUtils {
    private BundleDescriptorUtils() {
    }

    public static boolean isCompatibleVersion(String availableVersion, String expectedVersion) {
        Semver expected;
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)availableVersion), "availableVersion cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)expectedVersion), "expectedVersion cannot be empty");
        if (availableVersion.equals(expectedVersion)) {
            return true;
        }
        Semver available = BundleDescriptorUtils.getBundleVersion(availableVersion);
        if (available.isGreaterThan(expected = BundleDescriptorUtils.getBundleVersion(expectedVersion))) {
            return available.getMajor().equals(expected.getMajor());
        }
        return false;
    }

    private static Semver getBundleVersion(String version) {
        try {
            return new Semver(version, Semver.SemverType.LOOSE);
        }
        catch (SemverException e) {
            throw new InvalidDependencyVersionException(String.format("Unable to parse bundle version: %s, version is not following semantic versioning", version), e);
        }
    }
}

