/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactArchiveInstaller {
    protected static final String ANCHOR_FILE_BLURB = "Delete this file while Mule is running to remove the artifact in a clean way.";
    private static final Logger logger = LoggerFactory.getLogger(ArtifactArchiveInstaller.class);
    private final File artifactParentDir;

    public ArtifactArchiveInstaller(File artifactParentDir) {
        this.artifactParentDir = artifactParentDir;
    }

    public File installArtifact(URI artifactUri) throws IOException {
        if (!artifactUri.toString().toLowerCase().endsWith(".jar")) {
            throw new IllegalArgumentException("Invalid Mule artifact archive: '" + String.valueOf(artifactUri) + "'");
        }
        File artifactFile = new File(artifactUri);
        String baseName = FilenameUtils.getBaseName((String)artifactFile.getName());
        if (baseName.contains(" ")) {
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage("Mule artifact name may not contain spaces: '" + baseName + "'"));
        }
        File artifactDir = null;
        boolean errorEncountered = false;
        try {
            String artifactName;
            String fullPath = artifactFile.getAbsolutePath();
            if (logger.isInfoEnabled()) {
                logger.info("Exploding a Mule artifact archive: '" + fullPath + "'");
            }
            if ((artifactDir = new File(this.artifactParentDir, artifactName = FilenameUtils.getBaseName((String)fullPath))).exists() && !org.mule.runtime.core.api.util.FileUtils.deleteTree(artifactDir)) {
                throw new IOException("Cannot delete existing folder '" + String.valueOf(artifactDir) + "'");
            }
            File source = artifactFile;
            org.mule.runtime.core.api.util.FileUtils.unzip(source, artifactDir);
            if ("file".equals(artifactUri.getScheme()) && FileUtils.toFile((URL)artifactUri.toURL()).getAbsolutePath().startsWith(this.artifactParentDir.getAbsolutePath())) {
                FileUtils.deleteQuietly((File)source);
            }
        }
        catch (IOException e) {
            errorEncountered = true;
            throw e;
        }
        catch (Throwable t) {
            errorEncountered = true;
            String msg = "Failed to install artifact from URI: '" + String.valueOf(artifactUri) + "'";
            throw new DeploymentInitException(I18nMessageFactory.createStaticMessage(msg), t);
        }
        finally {
            if (errorEncountered && artifactDir != null && artifactDir.exists()) {
                org.mule.runtime.core.api.util.FileUtils.deleteTree(artifactDir);
            }
        }
        return artifactDir;
    }

    void uninstallArtifact(String artifactName) {
        try {
            File artifactDir = new File(this.artifactParentDir, artifactName);
            FileUtils.deleteDirectory((File)artifactDir);
            File marker = this.getArtifactAnchorFile(artifactName);
            marker.delete();
            Introspector.flushCaches();
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = String.format("Failed to undeployArtifact artifact [%s]", artifactName);
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
    }

    private File getArtifactAnchorFile(String artifactName) {
        return new File(this.artifactParentDir, String.format("%s%s", artifactName, "-anchor.txt"));
    }

    void createAnchorFile(String artifactName) throws IOException {
        File marker = this.getArtifactAnchorFile(artifactName);
        FileUtils.writeStringToFile((File)marker, (String)ANCHOR_FILE_BLURB);
    }
}

