/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;

public class ExtensionParsingContext {
    private final Map<String, MetadataType> parsedObjectTypes = new HashMap<String, MetadataType>();
    private final TypeCatalog typeCatalog;

    public ExtensionParsingContext(ExtensionModel extensionModel) {
        this.typeCatalog = TypeCatalog.getDefault(Collections.singleton(extensionModel));
    }

    public boolean registerObjectType(String name, String namespace, ObjectType type) {
        return this.parsedObjectTypes.put(this.generateObjectKey(name, namespace), type) == null;
    }

    public boolean isRegistered(String name, String namespace) {
        return this.parsedObjectTypes.containsKey(this.generateObjectKey(name, namespace));
    }

    public Collection<ObjectType> getSubTypes(ObjectType type) {
        return this.typeCatalog.getSubTypes(type);
    }

    public List<MetadataType> getAllBaseTypes() {
        return ImmutableList.copyOf(this.typeCatalog.getAllBaseTypes());
    }

    public List<MetadataType> getAllSubTypes() {
        return ImmutableList.copyOf(this.typeCatalog.getAllSubTypes());
    }

    private String generateObjectKey(String name, String namespace) {
        return name + namespace;
    }
}

