/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.runtime.module.extension.internal.loader.ExtensionDevelopmentFramework;
import org.mule.runtime.module.extension.internal.loader.ModelLoaderDelegateUtils;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.SdkApiDefinedModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.AllowedStereotypesModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

final class OperationModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private final Map<OperationModelParser, OperationDeclarer> operationDeclarers = new HashMap<OperationModelParser, OperationDeclarer>();

    OperationModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareOperations(ExtensionDeclarer extensionDeclarer, ExtensionDevelopmentFramework extensionDevelopmentFramework, HasOperationDeclarer ownerDeclarer, List<OperationModelParser> operations, ExtensionLoadingContext context) {
        for (OperationModelParser parser : operations) {
            boolean extensionLevelOperation;
            if (parser.isIgnored()) continue;
            boolean requiresConfig = ModelLoaderDelegateUtils.requiresConfig(extensionDevelopmentFramework, parser);
            HasOperationDeclarer actualDeclarer = requiresConfig ? ownerDeclarer : extensionDeclarer;
            boolean bl = extensionLevelOperation = actualDeclarer == extensionDeclarer;
            if (extensionLevelOperation && parser.isAutoPaging()) {
                throw new IllegalOperationModelDefinitionException(String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", parser.getName()));
            }
            if (extensionLevelOperation && requiresConfig) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", parser.getName()));
            }
            if (this.operationDeclarers.containsKey(parser)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(parser));
                continue;
            }
            this.operationDeclarers.put(parser, this.createOperationDeclarer(parser, extensionDeclarer, actualDeclarer, context));
        }
    }

    private OperationDeclarer createOperationDeclarer(OperationModelParser parser, ExtensionDeclarer extensionDeclarer, HasOperationDeclarer actualDeclarer, ExtensionLoadingContext context) {
        OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(parser.getName()).describedAs(parser.getDescription())).supportsStreaming(parser.supportsStreaming())).transactional(parser.isTransactional())).requiresConnection(parser.isConnected())).blocking(parser.isBlocking()).withVisibility(parser.getComponentVisibility());
        parser.getExecutorModelProperty().ifPresent(operation::withModelProperty);
        parser.getOutputType().applyOn(operation.withOutput());
        parser.getAttributesOutputType().applyOn(operation.withOutputAttributes());
        parser.getMediaTypeModelProperty().ifPresent(operation::withModelProperty);
        Optional<OutputResolverModelParser> outputResolverModelParser = parser.getOutputResolverModelParser();
        Optional<AttributesResolverModelParser> attributesResolverModelParser = parser.getAttributesResolverModelParser();
        List<InputResolverModelParser> inputResolverModelParsers = parser.getInputResolverModelParsers();
        Optional<MetadataKeyModelParser> keyIdResolverModelParser = parser.getMetadataKeyModelParser();
        ModelLoaderUtils.declareMetadataModelProperties((ParameterizedDeclaration)operation.getDeclaration(), outputResolverModelParser, attributesResolverModelParser, inputResolverModelParsers, keyIdResolverModelParser, parser.isConnected(), parser.getScopeChainInputTypeResolverModelParser(), parser.getRoutesChainInputTypesResolverModelParser());
        parser.getDeprecationModel().ifPresent(operation::withDeprecation);
        parser.getDisplayModel().ifPresent(d -> ((OperationDeclaration)operation.getDeclaration()).setDisplayModel((DisplayModel)d));
        if (context.isResolveMinMuleVersion()) {
            parser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> MinMuleVersionUtils.declarerWithMmv(operation, resolvedMMV));
        }
        this.loader.getParameterModelsLoaderDelegate().declare(operation, parser.getParameterGroupModelParsers(), context);
        ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)operation.getDeclaration(), parser);
        parser.getExecutionType().ifPresent(operation::withExecutionType);
        if (parser.isAutoPaging()) {
            ComponentDeclarationUtils.asPagedOperation(operation);
        }
        if (!parser.hasStreamingConfiguration()) {
            ComponentDeclarationUtils.withNoStreamingConfiguration(operation);
        }
        if (!parser.hasTransactionalAction()) {
            ComponentDeclarationUtils.withNoTransactionalAction(operation);
        }
        if (!parser.hasReconnectionStrategy()) {
            ComponentDeclarationUtils.withNoReconnectionStrategy(operation);
        }
        if (!parser.propagatesConnectivityError()) {
            ComponentDeclarationUtils.withNoConnectivityError(operation);
        }
        parser.getAdditionalModelProperties().forEach(operation::withModelProperty);
        parser.getExceptionHandlerModelProperty().ifPresent(operation::withModelProperty);
        this.declareChains(parser, operation, context);
        this.loader.registerOutputTypes((ExecutableComponentDeclaration)operation.getDeclaration());
        ModelLoaderDelegateUtils.declareErrorModels(operation, parser, extensionDeclarer, this.loader.createErrorModelFactory());
        this.getStereotypeModelLoaderDelegate().addStereotypes(parser, operation, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultOperationStereotype(parser.getName())));
        NotificationModelParserUtils.declareEmittedNotifications(parser, operation, this.loader::getNotificationModel);
        return operation;
    }

    private void declareChains(OperationModelParser parser, OperationDeclarer operation, ExtensionLoadingContext context) {
        if (parser.isScope()) {
            parser.getNestedChainParser().ifPresent(chain -> {
                NestedChainDeclarer chainDeclarer = ((NestedChainDeclarer)operation.withChain(chain.getName()).describedAs(chain.getDescription())).setRequired(chain.isRequired()).setExecutionOccurrence(chain.getExecutionOccurrence());
                ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)chainDeclarer.getDeclaration(), chain);
                this.getStereotypeModelLoaderDelegate().addAllowedStereotypes((AllowedStereotypesModelParser)chain, chainDeclarer);
                if (chain.isSdkApiDefined()) {
                    chainDeclarer.withModelProperty(SdkApiDefinedModelProperty.INSTANCE);
                }
            });
        } else if (parser.isRouter()) {
            parser.getNestedRouteParsers().forEach(route -> {
                NestedRouteDeclarer routeDeclarer = operation.withRoute(route.getName()).describedAs(route.getDescription()).withMinOccurs(route.getMinOccurs()).withMaxOccurs(route.getMaxOccurs().orElse(null));
                if (route.isSdkApiDefined()) {
                    routeDeclarer.withModelProperty(SdkApiDefinedModelProperty.INSTANCE);
                }
                NestedChainDeclarer chain = routeDeclarer.withChain().setExecutionOccurrence(route.getExecutionOccurrence());
                this.getStereotypeModelLoaderDelegate().addAllowedStereotypes((AllowedStereotypesModelParser)route, chain);
                route.getAdditionalModelProperties().forEach(routeDeclarer::withModelProperty);
                this.loader.getParameterModelsLoaderDelegate().declare(routeDeclarer, route.getParameterGroupModelParsers(), context);
            });
        }
    }
}

