/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class JavaObjectStoreParameterDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            final ExtensionDeclaration extension;
            boolean hasObjectStoreParams;
            {
                this.extension = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
                this.hasObjectStoreParams = false;
            }

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration parameter) {
                if (JavaObjectStoreParameterDeclarationEnricher.this.isObjectStore(parameter.getType())) {
                    List<StereotypeModel> stereotypes = parameter.getAllowedStereotypeModels();
                    if (!stereotypes.contains(MuleStereotypes.OBJECT_STORE)) {
                        stereotypes.add(MuleStereotypes.OBJECT_STORE);
                    }
                    this.hasObjectStoreParams = true;
                }
            }

            @Override
            public void onWalkFinished() {
                if (this.hasObjectStoreParams && !JavaObjectStoreParameterDeclarationEnricher.this.isObjectStoreAlreadyImported(this.extension)) {
                    ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
                    this.extension.getImportedTypes().add(new ImportedTypeModel((ObjectType)typeLoader.load((Type)((Object)ObjectStore.class))));
                }
            }
        });
    }

    private boolean isObjectStoreAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().filter(model -> this.isObjectStore(model.getImportedType())).findAny().isPresent();
    }

    private boolean isObjectStore(MetadataType type) {
        return MetadataTypeUtils.getTypeId(type).filter(typeId -> ObjectStore.class.getName().equals(typeId)).isPresent();
    }
}

