/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class JavaSubtypesModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        Map<ObjectType, Set<ObjectType>> typesMapping = ExtensionModelUtils.toSubTypesMap(model.getSubTypes());
        this.validateNonAbstractSubtypes(model, typesMapping, problemsReporter, new ReflectionCache());
    }

    private void validateNonAbstractSubtypes(ExtensionModel model, Map<ObjectType, Set<ObjectType>> typesMapping, ProblemsReporter problemsReporter, ReflectionCache reflectionCache) {
        LinkedList abstractSubtypes = new LinkedList();
        for (Set<ObjectType> subtypes : typesMapping.values()) {
            abstractSubtypes.addAll(subtypes.stream().filter(s -> !IntrospectionUtils.isInstantiable(s, reflectionCache)).map(ExtensionMetadataTypeUtils::getId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        }
        if (!abstractSubtypes.isEmpty()) {
            problemsReporter.addError(new Problem(model, String.format("All the declared Subtypes in extension %s should be of concrete types, but [%s] are non instantiable", model.getName(), Arrays.toString(abstractSubtypes.toArray()))));
        }
    }
}

