/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class ImplicitObjectUtils {
    private ImplicitObjectUtils() {
    }

    public static ResolverSet buildImplicitResolverSet(ParameterizedModel model, ReflectionCache reflectionCache, ExpressionManager expressionManager, MuleContext muleContext) {
        ResolverSet resolverSet = new ResolverSet(muleContext);
        ParametersResolver parametersResolver = ParametersResolver.fromDefaultValues(model, muleContext, reflectionCache, expressionManager);
        for (ParameterGroupModel groupModel : model.getParameterGroupModels()) {
            Optional<ParameterGroupDescriptor> descriptor = groupModel.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor);
            if (descriptor.isPresent() && groupModel.getParameterModels().stream().noneMatch(ParameterModel::isRequired)) {
                String groupKey = IntrospectionUtils.getContainerName(descriptor.get().getContainer());
                resolverSet.add(groupKey, NullSafeValueResolverWrapper.of(new StaticValueResolver<Object>(null), descriptor.get().getMetadataType(), reflectionCache, expressionManager, muleContext, parametersResolver));
                continue;
            }
            groupModel.getParameterModels().forEach(parameterModel -> {
                Object defaultValue = parameterModel.getDefaultValue();
                ValueResolver<Object> resolver = defaultValue instanceof String ? ResolverUtils.getExpressionBasedValueResolver((String)defaultValue, parameterModel.getType(), muleContext) : new StaticValueResolver<Object>(null);
                if (parameterModel.getModelProperty(NullSafeModelProperty.class).isPresent()) {
                    MetadataType metadataType = parameterModel.getModelProperty(NullSafeModelProperty.class).get().defaultType();
                    resolver = NullSafeValueResolverWrapper.of(resolver, metadataType, reflectionCache, expressionManager, muleContext, parametersResolver);
                }
                resolverSet.add(parameterModel.getName(), resolver);
            });
        }
        return resolverSet;
    }
}

