/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataResolverUtils;

class MetadataOutputDelegate
extends BaseMetadataDelegate {
    MetadataOutputDelegate(EnrichableModel model) {
        super(model);
    }

    Optional<String> getCategoryName() {
        return org.mule.runtime.extension.api.metadata.MetadataResolverUtils.getCategoryName(this.resolverFactory);
    }

    MetadataResult<OutputMetadataDescriptor> getOutputMetadataDescriptor(MetadataContext context, Object key) {
        if (!(this.model instanceof HasOutputModel)) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure().withMessage("The given component has not output definition to be described").onComponent());
        }
        MetadataResult<MetadataType> output = this.getOutputMetadata(context, key);
        MetadataResult<MetadataType> attributes = this.getOutputAttributesMetadata(context, key);
        HasOutputModel componentWithOutput = (HasOutputModel)((Object)this.model);
        MetadataResult<TypeMetadataDescriptor> outputDescriptor = this.toMetadataDescriptorResult(componentWithOutput.getOutput().getType(), componentWithOutput.getOutput().hasDynamicType(), output);
        MetadataResult<TypeMetadataDescriptor> attributesDescriptor = this.toMetadataDescriptorResult(componentWithOutput.getOutputAttributes().getType(), componentWithOutput.getOutputAttributes().hasDynamicType(), attributes);
        OutputMetadataDescriptor descriptor = OutputMetadataDescriptor.builder().withReturnType(outputDescriptor.get()).withAttributesType(attributesDescriptor.get()).build();
        if (!output.isSuccess() || !attributes.isSuccess()) {
            ImmutableList failures = ImmutableList.builder().addAll(output.getFailures()).addAll(attributes.getFailures()).build();
            return MetadataResult.failure(descriptor, (List<MetadataFailure>)failures);
        }
        return MetadataResult.success(descriptor);
    }

    Optional<NamedTypeResolver> getOutputResolver() {
        return this.getOptionalResolver(this.resolverFactory.getOutputResolver());
    }

    Optional<NamedTypeResolver> getOutputAttributesResolver() {
        return this.getOptionalResolver(this.resolverFactory.getOutputAttributesResolver());
    }

    private MetadataResult<MetadataType> getOutputMetadata(MetadataContext context, Object key) {
        OutputModel output = ((HasOutputModel)((Object)this.model)).getOutput();
        if (MetadataTypeUtils.isVoid(output.getType()) || !output.hasDynamicType()) {
            return MetadataResult.success(output.getType());
        }
        try {
            MetadataType metadata = MetadataResolverUtils.resolveWithOAuthRefresh(context, () -> this.resolverFactory.getOutputResolver().getOutputType(context, key));
            if (this.isMetadataResolvedCorrectly(metadata, true)) {
                return MetadataResult.success(this.adaptToListIfNecessary(metadata, key, context));
            }
            MetadataFailure failure = MetadataFailure.Builder.newFailure().withMessage("Error resolving Output Payload metadata").withFailureCode(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE).withReason("NullType is not a valid type for this element").onOutputPayload();
            return MetadataResult.failure(output.getType(), failure);
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).withMessage("Failed to establish connection: " + ExceptionUtils.getMessage((Throwable)e)).withFailureCode(FailureCode.CONNECTION_FAILURE).onComponent());
        }
        catch (Exception e) {
            return MetadataResult.failure(output.getType(), MetadataFailure.Builder.newFailure(e).onOutputPayload());
        }
    }

    private MetadataResult<MetadataType> getOutputAttributesMetadata(MetadataContext context, Object key) {
        OutputModel attributes = ((HasOutputModel)((Object)this.model)).getOutputAttributes();
        if (MetadataTypeUtils.isVoid(attributes.getType()) || !attributes.hasDynamicType()) {
            return MetadataResult.success(attributes.getType());
        }
        return this.resolveOutputAttributesMetadata(context, key, metadata -> this.isMetadataResolvedCorrectly((MetadataType)metadata, true));
    }

    private MetadataResult<MetadataType> resolveOutputAttributesMetadata(MetadataContext context, Object key, Function<MetadataType, Boolean> metadataValidator) {
        try {
            MetadataType metadata = MetadataResolverUtils.resolveWithOAuthRefresh(context, () -> this.resolverFactory.getOutputAttributesResolver().getAttributesType(context, key));
            if (metadataValidator.apply(metadata).booleanValue()) {
                return MetadataResult.success(metadata);
            }
            MetadataFailure failure = MetadataFailure.Builder.newFailure().withMessage("Error resolving Output Attributes metadata").withFailureCode(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE).withReason("NullType is not a valid type for this element").onOutputAttributes();
            return MetadataResult.failure(failure);
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).withMessage("Failed to establish connection: " + ExceptionUtils.getMessage((Throwable)e)).withFailureCode(FailureCode.CONNECTION_FAILURE).onComponent());
        }
        catch (Exception e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onOutputAttributes());
        }
    }

    private MetadataResult<TypeMetadataDescriptor> toMetadataDescriptorResult(MetadataType type, boolean isDynamic, MetadataResult<MetadataType> result) {
        MetadataType resultingType = result.get() == null ? type : result.get();
        TypeMetadataDescriptor descriptor = TypeMetadataDescriptor.builder().withType(resultingType).dynamic(isDynamic).build();
        return result.isSuccess() ? MetadataResult.success(descriptor) : MetadataResult.failure(descriptor, result.getFailures());
    }

    private MetadataType adaptToListIfNecessary(MetadataType resolvedType, Object key, MetadataContext metadataContext) throws MetadataResolvingException {
        MetadataType componentOutputType = ((HasOutputModel)((Object)this.model)).getOutput().getType();
        if (!MetadataTypeUtils.isCollection(componentOutputType) || MetadataTypeUtils.isVoid(resolvedType) || MetadataTypeUtils.isNullType(resolvedType)) {
            return resolvedType;
        }
        MetadataType collectionValueType = ((ArrayType)componentOutputType).getType();
        Class<?> collectionType = this.getCollectionType(collectionValueType);
        if (Message.class.equals(collectionType)) {
            MessageMetadataType message = (MessageMetadataType)collectionValueType;
            resolvedType = this.wrapInMessageType(resolvedType, key, metadataContext, message.getAttributesType());
        }
        return metadataContext.getTypeBuilder().arrayType().with(new ClassInformationAnnotation(this.getCollectionType(componentOutputType))).of(resolvedType).build();
    }

    private MetadataType wrapInMessageType(MetadataType type, Object key, MetadataContext context, Optional<MetadataType> staticAttributes) throws MetadataResolvingException {
        MessageMetadataTypeBuilder message = new MessageMetadataTypeBuilder().payload(type);
        staticAttributes.ifPresent(message::attributes);
        if (((HasOutputModel)((Object)this.model)).getOutputAttributes().hasDynamicType()) {
            MetadataResult<MetadataType> attributes = this.resolveOutputAttributesMetadata(context, key, Objects::nonNull);
            if (!attributes.isSuccess()) {
                throw new MetadataResolvingException("Could not resolve attributes of List<Message> output", attributes.getFailures().stream().map(MetadataFailure::getFailureCode).findFirst().orElse(FailureCode.UNKNOWN));
            }
            message.attributes(attributes.get());
        }
        return message.build();
    }

    private Class<?> getCollectionType(MetadataType type) {
        Class clazz = ExtensionMetadataTypeUtils.getType(type).orElseThrow(() -> new IllegalArgumentException("MetadataType has no class information"));
        if (PagingProvider.class.equals(clazz)) {
            return Iterator.class;
        }
        return clazz;
    }
}

