/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;

class DeferredExecutorCallback
implements CompletableComponentExecutor.ExecutorCallback,
AutoCloseable {
    private Throwable error = null;
    private boolean isErrorCalled = false;
    private Object result = null;
    private boolean isCompleteCalled = false;
    private final CompletableComponentExecutor.ExecutorCallback delegate;
    private boolean isEnabled = false;
    private ClassLoader savedClassLoader = null;

    DeferredExecutorCallback(CompletableComponentExecutor.ExecutorCallback delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized void complete(Object value) {
        this.isCompleteCalled = true;
        if (this.isEnabled) {
            this.delegate.complete(value);
        } else {
            this.result = value;
            this.savedClassLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    @Override
    public synchronized void error(Throwable e) {
        this.isErrorCalled = true;
        if (this.isEnabled) {
            this.delegate.error(e);
        } else {
            this.error = e;
            this.savedClassLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    @Override
    public synchronized void close() throws Exception {
        this.isEnabled = true;
        if (!this.isErrorCalled && !this.isCompleteCalled) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader outerClassLoader = currentThread.getContextClassLoader();
        ClassUtils.setContextClassLoader(currentThread, outerClassLoader, this.savedClassLoader);
        try {
            this.callDelegateMethod();
        }
        finally {
            ClassUtils.setContextClassLoader(currentThread, this.savedClassLoader, outerClassLoader);
        }
    }

    private void callDelegateMethod() {
        if (this.isErrorCalled) {
            this.delegate.error(this.error);
        }
        if (this.isCompleteCalled) {
            this.delegate.complete(this.result);
        }
    }
}

