/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source.legacy;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacyPollContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacyResultAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacySourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacySourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacySourceWrapper;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.PollContext;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkSourceAdapter<T, A>
extends org.mule.sdk.api.runtime.source.Source<T, A>
implements LegacySourceWrapper,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdkSourceAdapter.class);
    private final Source<T, A> delegate;

    public static <T, A> org.mule.sdk.api.runtime.source.Source<T, A> from(Source<T, A> delegate) {
        if (delegate instanceof org.mule.runtime.extension.api.runtime.source.PollingSource) {
            return new LegacyPollingSourceAdapter((org.mule.runtime.extension.api.runtime.source.PollingSource)delegate);
        }
        return new SdkSourceAdapter<T, A>(delegate);
    }

    private SdkSourceAdapter(Source<T, A> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onStart(SourceCallback<T, A> sourceCallback) throws MuleException {
        this.delegate.onStart(new LegacySourceCallbackAdapter<T, A>(sourceCallback));
    }

    @Override
    public void onStop() {
        this.delegate.onStop();
    }

    @Override
    public Source getDelegate() {
        return this.delegate;
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
    }

    private static class LegacyPollingSourceAdapter<T, A>
    extends PollingSource<T, A>
    implements LegacySourceWrapper,
    Initialisable,
    Disposable {
        private static final Logger LOGGER = LoggerFactory.getLogger(LegacyPollingSourceAdapter.class);
        private final org.mule.runtime.extension.api.runtime.source.PollingSource<T, A> delegate;

        private LegacyPollingSourceAdapter(org.mule.runtime.extension.api.runtime.source.PollingSource<T, A> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected void doStart() throws MuleException {
            this.delegate.onStart(null);
        }

        @Override
        protected void doStop() {
            this.delegate.onStop();
        }

        @Override
        public void poll(PollContext<T, A> pollContext) {
            this.delegate.poll(new LegacyPollContextAdapter<T, A>(pollContext));
        }

        @Override
        public void onRejectedItem(Result<T, A> result, SourceCallbackContext callbackContext) {
            this.delegate.onRejectedItem(LegacyResultAdapter.from(result), new LegacySourceCallbackContextAdapter(callbackContext));
        }

        @Override
        public Source getDelegate() {
            return this.delegate;
        }

        @Override
        public void initialise() throws InitialisationException {
            LifecycleUtils.initialiseIfNeeded(this.delegate);
        }

        @Override
        public void dispose() {
            LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        }
    }
}

